# -*- coding: utf-8 -*-

"""
Обрабатываем export_xmlhist.conf и выдираем news_title (для экспорта размера лота).
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys
sys.path.append(".")
from stocks3.core.config import parse_xml


def encode(s):
    if type(s) == str:
        return s.encode("utf-8")
    else:
        return s


if __name__ == "__main__":
    tree = parse_xml("/opt/www/stocks2/config/export/xml/export_xmlhist.conf")
    root = tree.getroot()

    for node in root.findall("export_ids/item"):
        if "news_title" in node.attrib:
            print(('%s "%s"'% (node.attrib["id"], encode(node.attrib["news_title"]))))


