#!/usr/bin/env python3
# coding: utf-8

"""
Очень простой скрипт - выдает список котировок с установленным флагом (флаг
принимается первым аргументов).
"""

import sys
import json
sys.path.append('.')
from stocks3.core.config import parse_xml, str_to_bool


QUOTES = 'catalog/quotes.json'


def encode(s):
    if type(s) == unicode:
        return s.encode('utf-8')
    else:
        return s


if __name__ == '__main__':
    if len(sys.argv) < 2:
        print('usage: %s <flags-list>' % sys.argv[0])
    with open(QUOTES) as fp:
        quotes = json.load(fp)
    for quote in quotes:
        quote_id = quote.get('id')
        for export_flag in quote.get('export-flags', {}):
            if export_flag in sys.argv[1:]:
                print('%s:%s' % (encode(quote.get('name')), encode(quote.get('id'))))

