# -*- coding: utf-8 -*-

"""
Запускает отдельно транспрорт.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

import sys
sys.path.append(".")
import stocks3
from stocks3.share.opts import Opts
from stocks3.core.place import TempFile

if __name__ == "__main__":
    stocks3.load_modules()
    opts = Opts(sys.argv)
    for source_file, source in opts.get_active_sources():
        for transport in source.transports:
            place = TempFile()
            try:
                if transport.is_valid_place(place):
                    print(transport.__class__.__name__)
                    transport.run_transfer(place)
                    f = open(place.filename, "rb")
                    print(f.read())
                    f.close()
            finally:
                place.clean()

