__author__ = 'aalogachev'

class ChannelSubtype():
    name = 'DEFAULT'

    def __init__(self, name):
        self.name = name

    def __unicode__(self):
        return self.name


class Channel():
    name = 'DEFAULT'
    subtypes = []
    map_name_to_subtype = None
    map_name_to_channel = None
    all_channels = None

    def __init__(self, name):
        self.name = name

    def __init__(self, name, subtypes):
        self(name)
        self.subtypes = subtypes

    def __unicode__(self):
        return u'{0}[{1}]'.format(self.name, u','.join(self.subtypes))

    def get_all_channels(self):
        # not thread safe
        # lazy init
        if self.all_channels is None:
            self.all_channels = [FacebookChannel(), GoogleChannel()]
        return self.all_channels

    def find_channel(self, name):
        # not thread safe
        # lazy init
        if (self.map_name_to_channel is None):
            self.map_name_to_channel = dict()
            for channel in self.get_all_channels():
                self.map_name_to_channel[channel.name] = channel
        return self.map_name_to_channel.get(name, None)

    def find_subtype(self, name):
        # not thread safe
        # lazy init
        if (self.map_name_to_subtype is None):
            self.map_name_to_subtype = dict()
            for subtype in self.subtypes:
                self.map_name_to_subtype[subtype.name] = subtype
        return self.map_name_to_subtype.get(name, None)


class GoogleChannel(Channel):
    def __init__(self):
        self('GOOGLE', [ChannelSubtype('SEARCH'), ChannelSubtype('SEARCH_PARTNERS'), ChannelSubtype('GDN')])


class FacebookChannel(Channel):
    def __init__(self):
        self('FACEBOOK', [ChannelSubtype('IN_FEED'), ChannelSubtype('RIGHT')])
