__author__ = 'aalogachev'

import requests, json, os, urllib2
import logging, ConfigParser
from ru.yandex import utils

logger = logging.getLogger('ru.yandex.direct.api_connector')

# reading config
config = ConfigParser.SafeConfigParser()
config.readfp(open(os.path.join(utils.get_project_path(),'config_direct.json')))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)

# reading access parameters from config
my_api_login = config.get(section=section, option='my_api_login')
api_login = config.get(section=section, option='api_login')
my_api_persistent_token = config.get(section=section, option='my_persistent_token')
api_token = config.get(section=section, option='api_token')
api_url = config.get(section=section, option='api_url')
api_v5_url = config.get(section=section, option='api_v5_url')

def call(method, data, usev5=False):
    data_to_send = {
        #'login' : my_api_login,
        #'persistent_token' : my_api_persistent_token,
        'login' : api_login,
        'token' : api_token,
        'method' : method,
        'param': data,
    }

    r = requests.post(
        api_url,
        data=json.dumps(data_to_send, ensure_ascii=False).encode('utf8'),
    )

    api_call_url = api_v5_url if usev5 else api_url
    logger.debug(u'Sending {0} to {1}'.format(json.dumps(data_to_send, ensure_ascii=False), api_call_url))
    logger.debug(u'Send data to \'{0}\' method \'{1}\' was completed with code {1}'.format(api_call_url, method, r.status_code))
    logger.info(u'Message = {0}'.format(r.text))
    return r.text
