#!/usr/bin/env python
#  -*- coding: utf-8 -*-

from __future__ import division
import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import logging, ConfigParser, os, json
import urlparse, urllib
from ru.yandex.direct import api_connector
from ru.yandex.googleads import campaigns_management as ga_camp

__author__ = 'aalogachev'


# setting logging
logging.basicConfig(level=logging.DEBUG)
logger = logging.getLogger('ru.yandex.direct.copy_from_adwords')

def convert_url_for_direct_from_adwords(url_in):
    url_parts = list(urlparse.urlparse(url_in))
    query = dict(urlparse.parse_qsl(url_parts[4]))
    query['utm_content']='source'
    query['utm_term']='phrase_id'
    query['utm_source']='yandex'
    query['utm_medium']='rsya'
    query['utm_campaign']=query['utm_campaign'].replace('_gdn', '_rsya')
    query['from']='direct_rsya'
    url_parts[4] = urllib.urlencode(query)
    finalUrl = urlparse.urlunparse(url_parts)
    finalUrl = finalUrl.replace(u'utm_term=phrase_id', u'utm_term={phrase_id}')
    finalUrl = finalUrl.replace(u'utm_content=source', u'utm_content={source}')
    return finalUrl

def convert_description_from_adwords(headline, description1, description2):
    #FIXME replace KeyWord with Yandex one
    res_headline = headline
    if  u'{keyword' in headline.lower():
        #replacing keyword for direct
        res_headline = res_headline.replace(u'{[kK]ey[wW]ord',u'#')
        res_headline = res_headline.replace(u'}',u'#')
        print res_headline
    res_description = u' '.join([description1, description2])
    return (res_headline, res_description)

def convert_keywords_from_adwords(keyword):
    #removing phrase and widing
    if keyword.startswith('[') or keyword.startswith('"'):
        keyword = keyword[1:len(keyword)-1]
    words = keyword.split(' ')
    #removing plus sign in the beggining of words
    for i in range (0, len(words)):
        word = words[i]
        if word.startswith('+'):
            words[i] = word[1:]
    #removing minus words
    for word in words:
        if word.startswith('-'):
            words.remove(word)
    return u' '.join(words)

def create_direct_campaign(campaign_name):
    campaign_data = {
        #FIXME Set proper login, FIO and other information
        'Login': u'switch-ru',
        'CampaignID': 0,
        'Name' : campaign_name,
        'FIO' : u'Switch RU',
        'Strategy' : {
            #IndependentControl only from web interface
            'StrategyName' : 'AverageClickPrice',
            #FIXME add correct price here
            'MaxPrice': 0.04 * 8, #8 руб
            'AveragePrice':0.04 * 8, #8 руб
        },
        'EmailNotification' : {
            'Email' : 'switch-ru@yandex.ru',
            'WarnPlaceInterval' : 60,
            'MoneyWarningValue' : 20,
        }
    }

    logger.info(u'Creating campaign {0}'.format(campaign_data['Name']))
    result = api_connector.call('CreateOrUpdateCampaign',campaign_data)
    return json.loads(result)['data']

def add_direct_ad_to_adgroup(campaign_id, adgroup_id, banners):
    ad_data = []
    for banner in banners:
        ad_data.append({
        'BannerID': 0,
        'CampaignID': campaign_id,
        'AdGroupID': adgroup_id,
        'Title': banner[0],
        'Text': banner[1],
        'Href': banner[2],
    })
    logger.info(u'Adding {0} banners to {1}'.format(len(ad_data), adgroup_id))
    result = api_connector.call('CreateOrUpdateBanners', ad_data)
    return json.loads(result)['data']

def stop_campaign(campaign_id):
    data = {
        'CampaignID' : campaign_id
    }
    result = api_connector.call('StopCampaign', data)
    return json.loads(result)['data']


def create_direct_adgroup(campaign_id,  ad_group_name, title, text, url, phrases):
    phrases_data = []
    for phrase in phrases:
        phrase_data = {
            'PhraseID': 0,
            'Phrase': phrase,
            #'Price' : 0.90,
            #'ContextPrice' : 0.90,
            'AutoBudgetPriority': 'Medium',
        }
        phrases_data.append(phrase_data)

    adgroup_data = [{
        'BannerID': 0,
        'CampaignID': campaign_id,
        'AdGroupID':0,
        'AdGroupName': ad_group_name,
        'Title': title,
        'Text' : text,
        'Href' : url,
        #225 - means Russia
        'Geo' : '225',
        # method GetRegions in API
        'Phrases' : phrases_data
    }]

    logger.info(u'Creating adgroup {0}'.format(ad_group_name))
    result = api_connector.call('CreateOrUpdateBanners',adgroup_data)
    res = json.loads(result)
    if res.has_key('error_code'):
        logger.error(result)
        #FIXME add return None and hadle this situation
    return res['data'][0]

def get_adgroup_id_for_banner(campaign_id, banner_id):
    request_data={
        'CampaignIDS': [campaign_id],
        'BannerIDS': [banner_id],
        "GetPhrases" : "No",
    }
    result = api_connector.call('GetBanners', request_data)
    #FIXME migrate to v5 protocol
    return json.loads(result)['data'][0]['AdGroupID']

def create_direct_advert():
    return

def list_direct_campaigns():
    return api_connector.call('GetCampaignsList', [])

def get_campaign_params(campaign_id):
    return api_connector.call('GetCampaignParams',{'CampaignID':campaign_id})

def split_phrases_into_groups(all_phrases):
    MAX_LETTERS_COUNT = 4096
    current_count = 0
    res = []
    cur_batch = []
    for phrase in all_phrases:
        phrase_len = len(phrase)
        if current_count + phrase_len + 1 >= MAX_LETTERS_COUNT:
            #creating new batch
            res.append(cur_batch)
            cur_batch = [phrase]
            current_count = phrase_len
        else:
            cur_batch.append(phrase)
            #adding phrase len plus delimiter length = 1
            current_count += phrase_len + 1
    #adding final batch
    res.append(cur_batch)
    return res

adwords_client = ga_camp.get_client();
all_campaigns = ga_camp.get_all_campaigns_with_label(adwords_client, ga_camp.LABEL_SWITCH_ID)
for campaign in all_campaigns:
    #FIXME remove filtering from here
    if str(campaign['name']).endswith(u'_switch_gdn') and \
                    campaign['name'] not in [u'КМС_Поиск_switch_gdn', u'КМС_Панорама_Россия_switch_gdn', u'КМС_Переводчик_switch_gdn']:
        logger.info(u'Processing campaign = {0}'.format(campaign['name']))
        adgroups = ga_camp.get_adgroups_for_campaign(adwords_client, campaign['id'])
        if adgroups is not None and len(adgroups)>0:
            campaign_id = create_direct_campaign(u'{0}'.format(campaign['name']))
            stop_campaign(campaign_id)
            for adgroup in adgroups:
                print adgroup

                #getting keywords
                keywords = ga_camp.get_keywords(adwords_client, adgroup['id'])
                direct_phrases = set()
                for keyword in keywords:
                    phrase = convert_keywords_from_adwords(keyword['criterion']['text'])
                    if len(phrase.split(' ')) > 6 or len(phrase) > 4050:
                        logger.warn(u'Phrase \'{0}\' is too long, ignoring'.format(phrase))
                    else:
                        direct_phrases.add(phrase)
                    logger.debug(u'Phrases = {0}'.format(phrase))

                if len(direct_phrases)==0:
                    logger.warn(u'No phrases for adgroup[{0}] = \'{1}\', so skipping it'.format(adgroup['id'], adgroup['name']))
                    continue
                #getting text ads and creating direct banners
                text_ads = ga_camp.get_text_ads(adwords_client, adgroup['id'])
                splitted_into_batches = split_phrases_into_groups(direct_phrases)
                banners = []
                for phrase_batch in splitted_into_batches:
                    isFirstBanner = True
                    for ad in text_ads:

                        #forming text and title
                        direct_ad_texts = convert_description_from_adwords(ad['ad']['headline'], ad['ad']['description1'], ad['ad']['description2'])
                        #forming url for ads
                        ad_finalUrls = ad['ad']['finalUrls']
                        if len(ad_finalUrls)>1:
                            logger.error(u'Ad {0} has more than 1 finalUrls'.format(ad['ad']['id']))
                        direct_url = convert_url_for_direct_from_adwords(ad_finalUrls[0])

                        if isFirstBanner:
                            #first time adgroup with phrases will be created
                            #FIXME add name generation if batches more than one
                            banner_id = create_direct_adgroup(campaign_id, u'{0}'.format(adgroup['name']), direct_ad_texts[0], direct_ad_texts[1], direct_url, phrase_batch)
                            adgroup_id = get_adgroup_id_for_banner(campaign_id, banner_id)
                            isFirstBanner = False
                        else:
                            #adding all other banners to banner update batch
                            banners.append((direct_ad_texts[0], direct_ad_texts[1], direct_url))
                    if len(banners)>0:
                        #adding all other banners to adgroup
                        add_direct_ad_to_adgroup(campaign_id, adgroup_id, banners)

#print api_connector.call('GetRegions', [])

