from facebookads.objects import AdAccount
from facebookads.api import FacebookAdsApi
from facebookads import FacebookSession
from facebookads.objects import (
    AdUser,
    AdLabel,
    AdCampaign,
    AdSet,
    AdImage,
    AdCreative,
    AdGroup,
    TargetingSpecsField,
)
from facebookads import objects
import logging
import os, time
import ConfigParser
from datetime import datetime, date, timedelta

#setting logging
logging.basicConfig(format='%(asctime)s : %(levelname)s : %(message)s', level=logging.DEBUG)
logger = logging.getLogger('facebook.account')

#reading config
config = ConfigParser.SafeConfigParser()
config.readfp(open('../../../config_facebook.json'))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)

#reading access parameters from config
my_app_id = config.get(section=section, option='app_id')
my_app_secret = config.get(section=section, option='app_secret')
my_access_token = config.get(section=section, option='access_token')
my_adv_account_id = config.get(section=section, option='adv_account_id')
turkey_adv_account_id = config.get(section=section, option='yndx_turkey_account_id')

### Setup session and api objects
session = FacebookSession(
    my_app_id,
    my_app_secret,
    my_access_token,
)
api = FacebookAdsApi(session)

if __name__ == '__main__':
    FacebookAdsApi.set_default_api(api)

    logger.info('********** Ad Creation example. **********')

    ### Setup user and read the object from the server
    me = AdUser(fbid='me')

    ### Get first account connected to the user
    my_account = me.get_ad_account()

    ### Read connections (in this case, the accounts connected to me)

    # Pro tip: Use list(me.get_ad_accounts()) to make a list out of
    # all the elements out of the iterator

    my_accounts_iterator = me.get_ad_accounts()
    logger.info('Reading accounts associated with user')
    for account in my_accounts_iterator:
        if account['account_id'] == turkey_adv_account_id:
            my_account = account

    assert isinstance(my_account, AdAccount)

    logger.info('Using account = ' + str(my_account))

    # logger.info('Listing existing labels')
    # gender_label = None
    # for label in my_account.get_ad_labels():
    #     logger.info('Label {}'.format(label))
    #     if label[AdLabel.Field.name] == 'gender_male' : gender_label = label
    #     if label[AdLabel.Field.name] == 'campaign_test' : test_campaign_label = label
    # if gender_label is None:
    #     ### Creating Gender Label if not exists
    #     gender_label = AdLabel(parent_id=my_account.get_id_assured())
    #     gender_label.update({
    #         AdLabel.Field.name: 'gender_male'
    #     })
    #     gender_label.remote_create()
    #     logger.info('Label created: {}'.format(gender_label))
    #
    #     test_campaign_label = AdLabel(parent_id=my_account.get_id_assured())
    #     test_campaign_label.update({
    #         AdLabel.Field.name: 'campaign_test'
    #     })
    #     test_campaign_label.remote_create()
    #     logger.info('Label created: {}'.format(test_campaign_label))


    default_campaign_fields = [
            AdCampaign.Field.name,
            AdCampaign.Field.status,
            AdCampaign.Field.objective,
            AdCampaign.Field.buying_type,
            AdCampaign.Field.adlabels,
    ]

    today = date.today()
    week_before = today - timedelta(days=7)

    insights_params = {
        'time_range': {
            'since': week_before.isoformat(),
            'until': today.isoformat(),
        },
        'filtering': [
            #using only link clicks
            {'field': 'action_type', 'operator': 'IN', 'value': ['link_click']}
        ],
        'level': 'adgroup',
        'fields': ['website_ctr', 'impressions', 'clicks', 'adgroup_id']
    }
    logger.debug('Using parameters for insights {}'.format(insights_params))


#    logger.info('Listing existing campaings')
#    for campaign in my_account.get_ad_campaigns():
#         assert isinstance(campaign, AdCampaign)
#         campaign.remote_read(fields=default_campaign_fields)
#         logger.info('Campaign {}'.format(campaign))

    campaign = AdCampaign(6025220951871) #campaign from yandex turkey account
    #campaign_insight = campaign.get_insights(params=insights_params)
    #logger.info('Camapign {} has insight {}'.format(campaign, campaign_insight))
    #campaign.remote_read(fields=default_campaign_fields)
    #logger.info('Campaign loaded {}'.format(campaign))

    ad_set = AdSet(6025279349471) #adset from yandex turkey account

    ad = AdGroup()

    exit(0)

    ### Create a Campaign
    campaign = AdCampaign(parent_id=my_account.get_id_assured())
    campaign.update({
        AdCampaign.Field.name: 'Seattle Ad Campaign',
        AdCampaign.Field.objective: AdCampaign.Objective.website_clicks,
        AdCampaign.Field.buying_type: AdCampaign.BuyingType.auction,
        AdCampaign.Field.status: AdCampaign.Status.paused,
        AdCampaign.Field.adlabels: [{'name':'gender_male'}, {'name':'campaign_test'}],
    })
    campaign.remote_create()
    logger.info('Campaign created: {}'.format(campaign))



    ### Create an Ad Set
    ad_set = AdSet(parent_id=my_account.get_id_assured())
    ad_set.update({
        AdSet.Field.name: 'Puget Sound AdSet',
        AdSet.Field.status: AdSet.Status.paused,
        AdSet.Field.optimization_goal: AdSet.OptimizationGoal.link_clicks,
        AdSet.Field.billing_event: AdSet.BillingEvent.impressions,
        AdSet.Field.bid_amount: 500,
        AdSet.Field.daily_budget: 20000,  # 200.00 in account currency
        AdSet.Field.start_time: int(time.time()) + 15,  # 15 seconds from now
        AdSet.Field.campaign_group_id: campaign.get_id_assured(),
        AdSet.Field.targeting: {
            TargetingSpecsField.geo_locations: {
                'countries': [
                    'US',
                ],
            },
        },
    })
    ad_set.remote_create()
    logger.info('Ad Set created: {}'.format(ad_set))


    ### Upload an image to an account.
    img = AdImage(parent_id=my_account.get_id_assured())
    image_file_path = os.path.join( os.path.dirname(__file__), '../../../Space_Needle002.jpg')
    logger.info('Uploading image file from ' + image_file_path)
    img.update({
        AdImage.Field.filename : image_file_path
    })
    img.remote_create()
    logger.info('Image with hash[{}] uploaded: {}'.format(img.get_hash(), img))

    ### Create a creative.
    creative = AdCreative(parent_id=my_account.get_id_assured())
    creative.update({
        AdCreative.Field.title: 'Visit Seattle',
        AdCreative.Field.body: 'Beautiful Puget Sound!',
        AdCreative.Field.object_url: 'http://www.seattle.gov/visiting/',
        #FIXME added url tags with dimensions
        AdCreative.Field.url_tags: 'cd_user_test=1',
        AdCreative.Field.image_hash: img.get_hash(),
    })
    creative.remote_create()
    logger.info('Creative created: {}'.format(creative))

    ### Get excited, we are finally creating an ad!!!
    ad = AdGroup(parent_id=my_account.get_id_assured())
    ad.update({
        AdGroup.Field.name: 'Puget Sound impression ad',
        AdGroup.Field.campaign_id: ad_set.get_id_assured(),
        AdGroup.Field.status: AdGroup.Status.paused,
        AdGroup.Field.creative: {
            AdGroup.Field.Creative.creative_id: creative.get_id_assured(),
        },
    })
    ad.remote_create()
    logger.info('Ad created: {}'.format(ad))

    ad.get_keyword_stats()








