from facebookads import FacebookSession, FacebookAdsApi
from facebookads.objects import AdUser, AdGroup, AdSet, AdCampaign, AdCreative, AdAccount
import types, os, logging, ConfigParser
from ru.yandex import utils as putils
__author__ = 'aalogachev'

logger = logging.getLogger('ru.yandex.facebook.api_connector')

# reading config
config = ConfigParser.SafeConfigParser()
config.readfp(open(os.path.join(putils.get_project_path(), 'config_facebook_public.json')))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)

def isField(x): #x is tuple of field name and value
    return ((not callable(x[0])) and (not isinstance(x[1], (type, types.ClassType))) and (not x[0].startswith('__')))

ad_campaign_fields = map(lambda x: x[1], filter(lambda x : isField(x), AdCampaign.Field.__dict__.items()))
ad_campaign_fields.remove('is_completed')
logger.debug('AdCampaign fields: {}'.format(ad_campaign_fields))

ad_set_fields = map(lambda x: x[1], filter(lambda x : isField(x), AdSet.Field.__dict__.items()))
logger.debug('AdSet fields: {}'.format(ad_set_fields))

ad_group_fields = map(lambda x: x[1], filter(lambda x : isField(x), AdGroup.Field.__dict__.items()))
ad_group_fields.remove('failed_delivery_checks')
ad_group_fields.remove('adgroup_status')
ad_group_fields.remove('social_prefs')
ad_group_fields.remove('campaign_id')
ad_group_fields.remove('view_tags')
ad_group_fields.remove('redownload')
ad_group_fields.remove('tracking_specs')
ad_group_fields.remove('creative')
ad_group_fields.remove('adgroup_review_feedback')
ad_group_fields.remove('conversion_specs')
logger.debug('AdGroup fields: {}'.format(ad_group_fields))


ad_creative_fields = {
    AdCreative.Field.actor_id,
    AdCreative.Field.actor_name,
    AdCreative.Field.adlabels,
    # AdCreative.Field.applink_treatment,
    AdCreative.Field.body,
    AdCreative.Field.call_to_action_type,
    # AdCreative.Field.filename,
    AdCreative.Field.follow_redirect,
    AdCreative.Field.id,
    AdCreative.Field.image_crops,
    # AdCreative.Field.image_file,
    AdCreative.Field.image_hash,
    AdCreative.Field.image_url,
    AdCreative.Field.link_deep_link_url,
    AdCreative.Field.link_url,
    AdCreative.Field.name,
    AdCreative.Field.object_id,
    AdCreative.Field.object_store_url,
    AdCreative.Field.object_story_id,
    AdCreative.Field.object_story_spec,
    AdCreative.Field.object_type,
    AdCreative.Field.object_url,
    AdCreative.Field.preview_url,
    AdCreative.Field.product_set_id,
    AdCreative.Field.template_url,
    AdCreative.Field.thumbnail_url,
    AdCreative.Field.title,
    AdCreative.Field.video_id,
}
ad_creative_fields = map(lambda x: x[1], filter(lambda x : isField(x), AdCreative.Field.__dict__.items()))
logger.debug('AdCreative fields: {}'.format(ad_creative_fields))



class ApiConnector(object):

    facebook_initialized = False
    account = None

    def __init__(self):
        if (not self.facebook_initialized):

            # reading access parameters from config
            my_app_id = config.get(section=section, option='app_id')
            my_app_secret = config.get(section=section, option='app_secret')
            my_access_token = config.get(section=section, option='access_token')
            my_adv_account_id = config.get(section=section, option='adv_account_id')

            ### Setup session and api objects
            session = FacebookSession(
                my_app_id,
                my_app_secret,
                my_access_token,
            )
            api = FacebookAdsApi(session)

            FacebookAdsApi.set_default_api(api)

            ### Setup user and read the object from the server
            #me = AdUser(fbid='me')

            self.account = AdAccount('act_{0}'.format(my_adv_account_id))

            #setting default read fields
            AdCampaign.set_default_read_fields(ad_campaign_fields)
            AdSet.set_default_read_fields(ad_set_fields)
            AdGroup.set_default_read_fields(ad_group_fields)
            AdCreative.set_default_read_fields(ad_creative_fields)

            self.facebook_initialized = True
        return

    def get_account(self):
        return self.account
