__author__ = 'aalogachev'

from facebookads.objects import TargetingSpecsField


class TargetingSplit:
    def __init__(self, targeting, labels, url_tags):
        self.targeting = targeting
        self.labels = labels
        self.url_tags = url_tags

    def intersect(self, other):
        temp_targeting = dict(self.targeting)
        temp_targeting.update(other.targeting)
        #FIXME add check that targetings can be intersected in easy way
        res = TargetingSplit (temp_targeting, self.labels + other.labels, self.url_tags + other.url_tags)
        return res

    def intersectWithTargeting(self, camp_targeting):
        new_camp_targeting = dict(camp_targeting)
        assert isinstance(self.targeting, dict)
        assert isinstance(camp_targeting, dict)
        for dim,value in self.targeting.iteritems():
            #gender intersection
            if dim == TargetingSpecsField.genders:
                value_tar = camp_targeting.get(dim, None)
                if value_tar is not None:
                    new_value =  [filter(lambda x: x in value_tar, sublist) for sublist in value]
                    new_camp_targeting[dim] = new_value
                else:
                    new_camp_targeting[dim] = value
            #age intersection
            if dim == TargetingSpecsField.age_max:
                value_tar = camp_targeting.get(dim, None)
                if value_tar is not None:
                    new_value_max = min(value,value_tar)
                    age_min = camp_targeting.get(TargetingSpecsField.age_min)
                    new_value_min = max(self.targeting.get(TargetingSpecsField.age_min), age_min)
                    if (new_value_min>new_value_max):
                        return None
                    new_camp_targeting[TargetingSpecsField.age_min] = new_value_min
                    new_camp_targeting[TargetingSpecsField.age_max] = new_value_max
                else:
                    new_camp_targeting[TargetingSpecsField.age_min] = self.targeting.get(TargetingSpecsField.age_min)
                    new_camp_targeting[TargetingSpecsField.age_max] = value
        return new_camp_targeting



class Dimension(object):
    def __init__(self, keyword, segments, intersects):
        self.keyword = keyword
        self.segments = segments
        self.intersects = intersects

    def get_targeting_splits(self):
        res = []
        for segment in self.segments:
            res.append(
                TargetingSplit({
                    self.keyword: segment},
                    ['{0}_{1}'.format(self.keyword, segment)],
                    ['cd_u_{0}={1}'.format(self.keyword, segment)]
                )
            )
        return res

class GenderDimension(Dimension):
    def __init__(self):
        super(GenderDimension, self).__init__('gender', [1, 2], False)
        #https://developers.facebook.com/docs/marketing-api/targeting-specs/v2.4
        #1 - means male
        #2 - means female

    def get_targeting_splits(self):
        res = []
        for segment in self.segments:
            res.append(
                TargetingSplit(
                    { TargetingSpecsField.genders: [segment]},
                    ['{0}_{1}'.format(self.keyword, segment)],
                    ['cd_u_{0}={1}'.format(self.keyword, segment)]
                )
            )
        return res

class AgeTNSDimension(Dimension):
    def __init__(self):
        super(AgeTNSDimension, self).__init__('age', [13, 18, 25, 35, 45, 55, 66], False)

    def get_targeting_splits(self):
        res = []

        for i in range (1, len(self.segments)):
            age_min = self.segments[i-1]
            age_max = self.segments[i]-1
            res.append(
                TargetingSplit(
                    {TargetingSpecsField.age_min: age_min,
                     TargetingSpecsField.age_max: age_max},
                    ['{0}_{1}-{2}'.format(self.keyword, age_min, age_max)],
                    ['cd_u_{0}={1}-{2}'.format(self.keyword, age_min, age_max)]
                )
            )
        return res
