__author__ = 'aalogachev'

import logging, os, ConfigParser
from facebookads import FacebookSession, FacebookAdsApi
from facebookads.objects import (AdLabel, AdSet, AdCampaign, AdUser, TargetingSpecsField, AdCreative, AdAccount, AdGroup, Insights)
from ru.yandex import utils

def get_object_string(ad_object, field_set):
    res = ''
    for field in field_set:
        res += '\t{}={}'.format(field, ad_object.get(field))
    return res

def get_object_insights_string(ad_object_insight, insight_fields):
    """
    :type ad_object_insight: Insights
    """
    logger.info(ad_object_insight)
    res = ''
    for field in insight_fields:
        for i in range(0, len(ad_object_insight)):
            if field == 'website_ctr':
                logger.debug(field)
                web_ctr = ad_object_insight[i].get(field)
                res += '\t{}_{}={}'.format(field, i, web_ctr[0].get('value'))
                logger.debug(res)
            else:
                logger.debug(field)
                res += '\t{}_{}={}'.format(field, i, ad_object_insight[0].get(field))
                logger.debug(res)
    return res

#setting logging
logging.basicConfig(format='%(asctime)s : %(levelname)s : %(message)s', level=logging.DEBUG)
logger = logging.getLogger('facebook.account')

#reading config
config = ConfigParser.SafeConfigParser()

config.readfp(open(os.path.join(utils.get_project_path(), 'config_facebook.json')))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)

#reading access parameters from config
my_app_id = config.get(section=section, option='app_id')
my_app_secret = config.get(section=section, option='app_secret')
my_access_token = config.get(section=section, option='access_token')
my_adv_account_id = config.get(section=section, option='adv_account_id')
project_path = utils.get_project_path()

### Setup session and api objects
session = FacebookSession(
    my_app_id,
    my_app_secret,
    my_access_token,
)
api = FacebookAdsApi(session)

default_ad_set_fields = [
    AdSet.Field.id,
    AdSet.Field.updated_time,
    AdSet.Field.status,
    AdSet.Field.name,
    AdSet.Field.adlabels,
    AdSet.Field.pacing_type,
    AdSet.Field.optimization_goal,
    AdSet.Field.bid_amount,
    AdSet.Field.is_autobid,
    AdSet.Field.bid_info,
    AdSet.Field.billing_event,
    AdSet.Field.daily_budget,
    AdSet.Field.lifetime_budget,
    AdSet.Field.campaign_schedule,
    AdSet.Field.rf_prediction_id,
]

default_ad_group_fields = [
    AdGroup.Field.id,
    AdGroup.Field.updated_time,
    AdGroup.Field.status,
    AdGroup.Field.adgroup_review_feedback,
]

default_insight_fields = ['website_ctr', 'impressions', 'clicks', 'date_start', 'date_stop']

default_insights_params = {
    'filtering': [
        #using only link clicks
        {'field': 'action_type', 'operator': 'IN', 'value': ['link_click']}
    ],
    #breakdowns=age,gender
    #FIXME can use other time period
    'date_preset': 'last_7_days',
    #'level': 'adgroup',
    #'fields': default_insight_fields,
}

if __name__ == '__main__':
    FacebookAdsApi.set_default_api(api)
    logger.info('********** Ad Creation example. **********')

    ### Setup user and read the object from the server
    me = AdUser(fbid='me')

    ### Get first account connected to the user
    my_account = me.get_ad_account()

    ### Read connections (in this case, the accounts connected to me)

    my_accounts_iterator = me.get_ad_accounts()
    logger.info('Reading accounts associated with user')
    for account in my_accounts_iterator:
        if account['account_id'] == my_adv_account_id:
            my_account = account

    assert isinstance(my_account, AdAccount)

    logger.info('Using account = ' + str(my_account))

    campaign = AdCampaign(6025220951871)
    ad_sets = campaign.get_ad_sets(fields=default_ad_set_fields)
    ad_groups = campaign.get_ad_groups(fields=default_ad_group_fields)
    logger.info("AdSets loaded")

    out_ad_sets = open(os.path.join(project_path, 'temp_ad_sets.txt'), mode='w')
    for ad_set in ad_sets:
        assert isinstance(ad_set, AdSet)
        insights = ad_set.get_insights(params=default_insights_params, fields=default_insight_fields)
        out_ad_sets.write(get_object_string(ad_set, default_ad_set_fields))
        if ad_set.get(AdSet.Field.status) == AdSet.Status.active :
            out_ad_sets.write(get_object_insights_string(insights, default_insight_fields))
        out_ad_sets.write('\n')
    out_ad_sets.close()

    out_ad_groups = open(os.path.join(project_path, 'temp_ad_groups.txt'), mode='w')
    for ad_group in ad_groups:
        out_ad_groups.write(get_object_string(ad_group, default_ad_group_fields))
        assert isinstance(ad_group, AdGroup)
        insights = ad_group.get_insights(params=default_insights_params, fields=default_insight_fields)
        if ad_group.get(AdGroup.Field.status) == AdGroup.Status.active:
            out_ad_groups.write(get_object_insights_string(insights, default_insight_fields))
        out_ad_groups.write('\n')
    out_ad_groups.close()





