# coding=utf-8
from __future__ import division
from facebookads import FacebookAdsApi, FacebookSession
from facebookads.objects import AdUser, AdAccount, Insights
from ru.yandex import utils
import os, logging, ConfigParser
from datetime import date, timedelta
from ru.yandex.statface import reports

__author__ = 'aalogachev'

# setting logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger('ru.yandex.facebook.get_facebook_campaigns_report')

# reading config
config = ConfigParser.SafeConfigParser()
config.readfp(open(os.path.join(utils.get_project_path(),'config_facebook_public.json')))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)

# reading access parameters from config
my_app_id = config.get(section=section, option='app_id')
my_app_secret = config.get(section=section, option='app_secret')
my_access_token = config.get(section=section, option='access_token')
my_adv_account_id = config.get(section=section, option='adv_account_id')
turkey_adv_account_id = config.get(section=section, option='yndx_turkey_account_id')

def get_action_type_value(actions, action_type):
    for action in actions:
        if action.get('action_type') == action_type:
            return action.get('value')
    return 0

def extract_data_line(item, report_date_start):
    data_line = {}
    data_line['fielddate'] = report_date_start.isoformat()
    if item.get('campaign_group_name', None) is None:
        data_line['campaign_name'] = u'\tFacebook\t'
    else:
        data_line['campaign_name'] = u'\tFacebook\t{0}\t'.format(item.get('campaign_group_name'))
    #data_line['average_position'] =
    assert isinstance(item, Insights)
    data_line['impressions'] = item.get('impressions')
    actions = item.get('actions', None)
    if actions is not None:
        data_line['clicks'] = int(get_action_type_value(actions, 'link_click'))
        data_line['conversions'] = int(get_action_type_value(actions, 'offsite_conversion'))
    data_line['money_spent'] = item.get('spend')
    data_line['cpm'] = item.get('cpm')
    cost_actions = item.get('cost_per_action_type',None)
    if cost_actions is not None:
        data_line['cpc'] = get_action_type_value(cost_actions, 'link_click')
        data_line['cpa'] = get_action_type_value(cost_actions, 'offsite_conversion')
    web_ctr = item.get('website_ctr', None)
    if web_ctr is not None:
        data_line['ctr'] = get_action_type_value(web_ctr, 'link_click')
    if (data_line.has_key('clicks') and data_line['clicks'] != 0):
        data_line['cvr'] = data_line['conversions'] / data_line['clicks']
    return data_line

def main(account, report_date):
    report_date_end = report_date + timedelta(days=1)
    report_date_start = report_date

    params ={
        'time_interval':{
            'day_start':{
                'year':report_date_start.year,'month': report_date_start.month,'day':report_date_start.day
            }, 'day_stop':{
                'year':report_date_end.year,'month': report_date_end.month,'day':report_date_end.day
            }
        },
        'fields': ['campaign_group_name', 'relevance_score', 'impressions', 'website_clicks', 'actions', 'spend', 'cpm', 'cpc',  'ctr', 'cost_per_action_type', 'website_ctr', ],
        # 'filtering' : [
        #     {
        #         'field': 'action_type',
        #         'operator': 'EQUAL',
        #         'value' : 'link_click'
        #     }]
    }
    data = []

    #account level reporting
    report = account.get_insights(params=params)
    for item in report:
        data_line = extract_data_line(item, report_date_start)
        data.append(data_line)

    #campaign level reporting
    params.update({'level': 'campaign_group'})
    report = account.get_insights(params=params)

    for item in report:
        data_line = extract_data_line(item, report_date_start)
        data.append(data_line)

    reports.send('ExtData/Switch_RU/All_Data_new', data)



if __name__ == '__main__':

    ### Setup session and api objects
    session = FacebookSession(
        my_app_id,
        my_app_secret,
        my_access_token,
    )
    api = FacebookAdsApi(session)
    FacebookAdsApi.set_default_api(api)

    me = AdUser(fbid='me')
    my_account = AdAccount('act_{0}'.format(turkey_adv_account_id))

    logger.info(u'Using account = ' + str(my_account))

    main(my_account, date.today() - timedelta(days=1))

