__author__ = 'aalogachev'

from facebookads.objects import AdCampaign, AdSet, AdGroup, AdCreative
import logging
from ru.yandex.facebook import api_connector as facebook_connector

logger = logging.getLogger('ru.yandex.facebook.list_utils')

def log_campaign(id=None):
    ad_campaign = AdCampaign(id)
    ad_campaign.remote_read(fields=facebook_connector.ad_campaign_fields)
    logger.info('AdCampaign: {}'.format(ad_campaign))

def log_adset(id=None):
    ad_set = AdSet(id)
    ad_set.remote_read(fields=facebook_connector.ad_set_fields)
    logger.info('AdSet: {}'.format(ad_set))

def log_adgroup(id = None):
    ad_group = AdGroup(id)
    ad_group.remote_read(fields=facebook_connector.ad_group_fields)
    logger.info('AdGroup: {}'.format(ad_group))

def log_adcreative(id=None):
    ad_creative = AdCreative(id)
    ad_creative.remote_read(fields=facebook_connector.ad_creative_fields)
    logger.info('AdCreative: {}'.format(ad_creative))


if __name__ == '__main__':

    #initializing facebook connector
    facebook_connector.ApiConnector()

    log_campaign(6029373108432)
    log_adset(6029373109232)
    log_adgroup(6029675076432)
    #log_adcreative(<id_here>)


