import facebook
import ConfigParser
import logging

logging.basicConfig(format='%(asctime)s : %(levelname)s : %(message)s', level=logging.ERROR)
logger = logging.getLogger('facebook.prolong_token')


config_file = '../../../config_facebook_public.json'
config = ConfigParser.SafeConfigParser()
config.readfp(open(config_file))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)
#'1058748500809835'
#'32078f742978b16a6a59641ea89abf13'
#'CAAPC7RhMGGsBAGsFT61qh4WV14ZBH6ojiohh1cQs5uKowZBBCCM4FxiH5nzZB7IzMosZAXyHmHXIbfHZAFOZAbdvxxl6ko2um1gJPeAoNCCyJGAEOicrce38xFkdQbveZBGjVCQ2S2eEzGfuLpr8oZCjoi64PoftasFewMsD6VlisvsmpQcDN4zeQVvfupzg1dQZD'

my_app_id = config.get(section=section, option='app_id')
my_app_secret = config.get(section=section, option='app_secret')
my_access_token = config.get(section=section, option='access_token')

graph = facebook.GraphAPI(my_access_token)

# Extend the expiration time of a valid OAuth access token.
extended_token = graph.extend_access_token(my_app_id, my_app_secret)
print 'NEW TOKEN RECEIVED = ' + str(extended_token)
config.set(section=section, option='access_token', value=extended_token['access_token'])
config.write(open(config_file,mode='w'))
#verify that it expires in 60 days
