from __future__ import division
import sys

reload(sys)
sys.setdefaultencoding("utf-8")

__author__ = 'aalogachev'

import logging, time
from datetime import date, timedelta
from googleads import adwords
from ru.yandex.statface import reports

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger('ru.yandex.googleads.get_adwords_campaign_report')

LABEL_SWITCH_ID = 282102254
PAGE_SIZE = 500


def get_adgroups_for_campaign(client, campaign_id):
    res = []
    # Initialize appropriate service.
    ad_group_service = client.GetService('AdGroupService', version='v201506')

    # Construct selector and get all ad groups.
    offset = 0
    selector = {
        'fields': ['Id', 'Name', 'Status'],
        'predicates': [
            {
                'field': 'CampaignId',
                'operator': 'EQUALS',
                'values': [campaign_id]
            }
        ],
        'paging': {
            'startIndex': str(offset),
            'numberResults': str(PAGE_SIZE)
        }
    }
    more_pages = True
    while more_pages:
        page = ad_group_service.get(selector)

        # Display results.
        if 'entries' in page:
            for ad_group in page['entries']:
                res.append(ad_group)
        offset += PAGE_SIZE
        selector['paging']['startIndex'] = str(offset)
        more_pages = offset < int(page['totalNumEntries'])
    return res


def get_client():
    return adwords.AdWordsClient.LoadFromStorage()

def create_campaign_from_file(data_filename, templates_filename):
    res = None
    adwords_campaign_url = ''
    return adwords_campaign_url


def get_all_campaigns_with_label(client, label_id):
    res = []
    # Initialize appropriate service.
    campaign_service = client.GetService('CampaignService', version='v201506')

    offset = 0
    selector = {
        'fields': ['Id', 'Name', 'Status'],
        # Labels filtering is performed by ID. You can use CONTAINS_ANY to select
        # campaigns with any of the label IDs, CONTAINS_ALL to select campaigns
        # with all of the label IDs, or CONTAINS_NONE to select campaigns with
        # none of the label IDs.
        'ordering': {
            'field': 'Name',
            'sortOrder': 'ASCENDING'
        },
        'paging': {
            'startIndex': str(offset),
            'numberResults': str(PAGE_SIZE)
        },
        'predicates': {
            'field': 'Labels',
            'operator': 'CONTAINS_ANY',
            'values': [label_id]
        }
    }

    more_pages = True
    while more_pages:
        page = campaign_service.get(selector)

        # Display results.
        if 'entries' in page:
            for campaign in page['entries']:
                res.append(campaign)

        offset += PAGE_SIZE
        selector['paging']['startIndex'] = str(offset)
        more_pages = offset < int(page['totalNumEntries'])
    return res


def get_text_ads(client, ad_group_id):
    res = []
    # Initialize appropriate service.
    ad_group_ad_service = client.GetService('AdGroupAdService', version='v201506')

    # Construct selector and get all ads for a given ad group.
    offset = 0
    selector = {
        'fields': ['Id', 'AdGroupId', 'Status', 'CreativeFinalUrls', 'DisplayUrl', 'Headline', 'Description1',
                   'Description2'],
        'predicates': [
            {
                'field': 'AdGroupId',
                'operator': 'EQUALS',
                'values': [ad_group_id]
            },
            {
                'field': 'AdType',
                'operator': 'EQUALS',
                'values': ['TEXT_AD']
            }
        ],
        'paging': {
            'startIndex': str(offset),
            'numberResults': str(PAGE_SIZE)
        }
    }
    more_pages = True
    while more_pages:
        page = ad_group_ad_service.get(selector)

        # Display results.
        if 'entries' in page:
            for ad in page['entries']:
                res.append(ad)
        offset += PAGE_SIZE
        selector['paging']['startIndex'] = str(offset)
        more_pages = offset < int(page['totalNumEntries'])
    return res


def get_keywords(client, ad_group_id):
    res = []
    # Initialize appropriate service.
    ad_group_criterion_service = client.GetService(
        'AdGroupCriterionService', version='v201506')

    # Construct selector and get all ad group criteria.
    offset = 0
    selector = {
        'fields': ['AdGroupId', 'Id', 'Text', 'KeywordMatchType', 'PlacementUrl'],
        'predicates': [
            {
                'field': 'CriteriaType',
                'operator': 'EQUALS',
                'values': ['KEYWORD']
            },
            {
                'field': 'AdGroupId',
                'operator': 'EQUALS',
                'values': [ad_group_id]
            }
        ],
        'paging': {
            'startIndex': str(offset),
            'numberResults': str(PAGE_SIZE)
        }
    }
    more_pages = True
    while more_pages:
        page = ad_group_criterion_service.get(selector)

        # Display results.
        if 'entries' in page:
            for criterion in page['entries']:
                res.append(criterion)
        offset += PAGE_SIZE
        selector['paging']['startIndex'] = str(offset)
        more_pages = offset < int(page['totalNumEntries'])
    return res
