from __future__ import division
import sys
reload(sys)
sys.setdefaultencoding("utf-8")

__author__ = 'aalogachev'

import logging
import requests, json
from datetime import date, timedelta
from googleads import adwords
from ru.yandex.statface import reports

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger('ru.yandex.googleads.get_adwords_campaign_report')

LABEL_SWITCH_ID = 282102254


def main(client, report_date):
    report_downloader = client.GetReportDownloader(version='v201506')

    # Create report definition for yesterday

    report = {
        'reportName': 'Last 7 days CAMPAIGN_PERFORMANCE_REPORT',
        'dateRangeType': 'CUSTOM_DATE',
        #'reportType': 'CRITERIA_PERFORMANCE_REPORT',
        'reportType' : 'CAMPAIGN_PERFORMANCE_REPORT',
        'downloadFormat': 'CSV',
        'selector': {
            #'fields': ['CampaignName', 'AveragePosition', 'Impressions', 'Clicks', 'ConvertedClicks', 'Cost', 'AverageCpm', 'AverageCpc', 'CostPerConvertedClick', 'Ctr', 'ClickConversionRate', 'CampaignId'],
            'fields': ['CampaignName', 'AveragePosition', 'Impressions', 'Clicks', 'ConvertedClicks', 'Cost', 'AverageCpm', 'AverageCpc', 'CostPerConvertedClick', 'Ctr', 'ClickConversionRate', 'CampaignId', 'CampaignStatus', 'BiddingStrategyType', 'Labels', 'LabelIds'],
            'dateRange' : {
                'min' : report_date.strftime('%Y%m%d'),
                'max' : report_date.strftime('%Y%m%d'),
            },
            'predicates': {
                'field': 'LabelIds',
                'operator': 'CONTAINS_ANY',
                'values': [LABEL_SWITCH_ID]
            },
        }
    }

    # You can provide a file object to write the output to. For this demonstration
    # we use sys.stdout to write the report to the screen.
    #report_downloader.DownloadReport(
    #    report, sys.stdout, skip_report_header=False, skip_column_header=False,
    #    skip_report_summary=False, include_zero_impressions=False)
    logger.info(u'Asking GoogleAds for report')
    report_resp = report_downloader.DownloadReportAsString(report, skip_report_header=True, skip_column_header=True, skip_report_summary=False, include_zero_impressions=False)
    logger.info(u'Report form GoogleAds recieved')
    #do conversion for money, add date and so on
    MONEY_RATIO = 1000000
    #field_names = ['campaign_name', 'average_position','impressions','clicks','conversions','money_spent','cpm','cpc','cpa','ctr','cvr', 'campaign_id', 'bidding_type', 'status']
    field_names = ['campaign_name', 'average_position','impressions','clicks','conversions','money_spent','cpm','cpc','cpa','ctr','cvr']
    data = []
    for line in report_resp.split('\n'):
        if line =='': break #last line is empty line we breaking here
        data_line = {}
        fields = line.split(',')
        for i in range (0, len(field_names)):
            data_line[field_names[i]]=fields[i]

        data_line['fielddate'] = report_date.isoformat()
        if data_line['campaign_name'] == 'Total':
            data_line['campaign_name'] = u'\tAdWords\t'
        else:
            data_line['campaign_name'] = u'\tAdWords\t{0}\t'.format(data_line['campaign_name'])

        data_line['money_spent'] = str(int(data_line['money_spent']) / MONEY_RATIO)
        data_line['cpm'] = str(int(data_line['cpm']) / MONEY_RATIO)
        data_line['cpc'] = str(int(data_line['cpc']) / MONEY_RATIO)
        data_line['cpa'] = str(int(data_line['cpa']) / MONEY_RATIO)
        #removing % from percents fields
        data_line['ctr'] = data_line['ctr'][:-1]
        data_line['cvr'] = data_line['cvr'][:-1]

        data.append(data_line)

    reports.send('ExtData/Switch_RU/All_Data_new', data) # AdWords
    #reports.send('ExtData/Switch_RU/AdWords', data)

if __name__ == '__main__':
  adwords_client = adwords.AdWordsClient.LoadFromStorage()
  curdate = date.today()
  for i in range (0,4):
      curdate = curdate - timedelta(days=1)
      main(adwords_client, curdate)

