# coding=utf-8
import sys

reload(sys)
sys.setdefaultencoding("utf-8")
import json, os, logging, datetime, collections, urllib, urlparse
from string import Template
from ru.yandex.googleads import campaigns_management as ga_camp
from datetime import time

__author__ = 'aalogachev'
logger = logging.getLogger('ru.yandex.googleads.templates')

FINAL_URL_FIELD = 'final_url'
ALL_PHRASES_FIELD = 'final_phrases'
DISPLAY_URL_FIELD = 'display_url'
# https://developers.google.com/adwords/api/docs/appendix/geotargeting
DEFAULT_GEO_CRITERION = '2792'  # means Turkey


def validate_params(params):
    raise Exception('Not implemented')


def load_template(filename):
    res = json.load(filename)
    return res


def create_budget(client, micro_amount):
    # FIXME change api version and throw exception for amount
    if micro_amount <= 0:
        logger.error(u'Budget amount is not positive')
        return None
    budget_service = client.GetService('BudgetService', version='v201506')

    # Create a budget, which can be shared by multiple campaigns.
    budget = {
        'name': u'Бюджет на эксперименты от {0}'.format(datetime.date.today()),
        'amount': {
            'microAmount': micro_amount
        },
        'deliveryMethod': 'STANDARD',
        'period': 'DAILY'
    }

    budget_operations = [{
        'operator': 'ADD',
        'operand': budget
    }]

    # Add the budget.
    budget_id = budget_service.mutate(budget_operations)['value'][0][
        'budgetId']
    logger.warn(u'AutoBudget with id={0} created. Please, save this id for later use'.format(budget_id))
    return budget_id


def create_new_campaign(client, params, budget_id):
    campaign_service = client.GetService('CampaignService', version='v201506')
    campaign_criterion_service = client.GetService('CampaignCriterionService', version='v201506')

    campaign = params.get('campaign')
    campaign_channelsubtype = campaign.get('channel_subtype')
    campaign_start_date = campaign.get('start_date') if campaign.has_key(
        'start_date') else datetime.datetime.now().strftime('%Y%m%d')
    campaign_end_date = campaign.get('end_date') if campaign.has_key('end_date') else (
        time.strptime(campaign_start_date, '%Y%m%d') + datetime.timedelta(days=28)).strftime('%Y%m%d')
    operations = [{
        'operator': 'ADD',
        'operand': {
            'name': u'{0} | {1}'.format(campaign.get('name'), datetime.datetime.now()),
            'status': 'PAUSED',
            'advertisingChannelType': 'SEARCH',
            'biddingStrategyConfiguration': {
                'biddingStrategyType': 'MANUAL_CPC',
            },
            # default 4 weeks from now duration
            'endDate': campaign_end_date,
            'budget': {
                'budgetId': budget_id
            },
            'networkSetting': {
                'targetGoogleSearch': 'true' if campaign_channelsubtype in ['GOOGLE_SEARCH',
                                                                            'SEARCH_NETWORK'] else 'false',
                'targetSearchNetwork': 'true' if campaign_channelsubtype == 'SEARCH_NETWORK' else 'false',
                'targetContentNetwork': 'true' if campaign_channelsubtype == 'CONTENT_NETWORK' else 'false',
                'targetPartnerSearchNetwork': 'false'
            },
            # Optional fields
            'startDate': campaign_start_date,
            'adServingOptimizationStatus': 'ROTATE',
            # FIXME think about frequency capping
            'frequencyCap': {
                'impressions': '5',
                'timeUnit': 'DAY',
                'level': 'ADGROUP'
            },
            'settings': [
                {
                    'xsi_type': 'GeoTargetTypeSetting',
                    'positiveGeoTargetType': 'LOCATION_OF_PRESENCE',
                }
            ]
        }
    }]
    campaigns = campaign_service.mutate(operations)
    # number of campaigns created = 1
    for campaign in campaigns['value']:
        campaign_id = campaign['id']


    # setting geo targeting
    operations = [{
        'operator': 'ADD',
        'operand': {
            'campaignId': campaign_id,
            'criterion': {
                'xsi_type': 'Location',
                'id': DEFAULT_GEO_CRITERION,
            }
        }
    }]
    # Make the mutate request.
    result = campaign_criterion_service.mutate(operations)

    # adding labels
    # FIXME implement adding labels
    # operations = [
    #     {
    #         'operator': 'ADD',
    #         'operand': {
    #             'campaignId': campaign_id1,
    #             'labelId': label_id,
    #         }
    #     },
    #     {
    #         'operator': 'ADD',
    #         'operand': {
    #             'campaignId': campaign_id2,
    #             'labelId': label_id,
    #         }
    #     }
    # ]

    # result = campaign_service.mutateLabel(operations)
    return campaign_id


def get_phrase_type_and_phrase(initial_phrase):
    assert isinstance(initial_phrase, basestring)
    if initial_phrase.startswith('['):
        return ('EXACT', initial_phrase[1:-1])
    if initial_phrase.startswith('"'):
        return ('PHRASE', initial_phrase[1:-1])
    else:
        return ('BROAD', initial_phrase)


def create_adgroups(client, params, params_dict, campaign_id, map_keywords_id_keywords):
    map_landing_id_adgroup_id = dict()

    ad_group_service = client.GetService('AdGroupService', version='v201506')
    ad_group_modifier_service = client.GetService(
            'AdGroupBidModifierService', version='v201506')
    ad_group_criterion_service = client.GetService('AdGroupCriterionService', version='v201506')
    operations = []

    cpc_bid = float(params.get('campaign').get('cpc_bid'))
    map_adgroup_name_to_landing_id = dict()
    for landing in params['landings']:
        adgroup_name = u'Группа {0}'.format(landing.get('id'))
        operations.append({
            'operator': 'ADD',
            'operand': {
                'campaignId': campaign_id,
                'name': adgroup_name,
                'status': 'ENABLED',
                'biddingStrategyConfiguration': {
                    'bids': [
                        {
                            'xsi_type': 'CpcBid',
                            'bid': {
                                'microAmount': int(cpc_bid * 1000000)
                            }
                        }
                    ]
                }
            }
        })
        # storing correspondance into map
        map_adgroup_name_to_landing_id[adgroup_name] = landing['id']

    ad_groups = ad_group_service.mutate(operations)
    bid_modification_operations = []
    for ad_group in ad_groups['value']:
        landing_id = map_adgroup_name_to_landing_id.get(ad_group['name'])
        map_landing_id_adgroup_id[landing_id] = ad_group['id']

        bid_modification_operations.append({ 'operator': 'ADD', 'operand': {
                'adGroupId': ad_group['id'],
                'criterion': { 'xsi_type': 'Platform', 'id': '30001' },
                'bidModifier': 0.0 }
        })
    bid_modifications = ad_group_modifier_service.mutate(bid_modification_operations)

    # adding keywords
    # TODO split into 2 functions (create adgroups, add keywords)
    operations = []
    for landing in params['landings']:
        landing_id = landing.get('id')
        ad_group_id = map_landing_id_adgroup_id.get(landing_id)
        for keyword_group_id in landing.get('keywords'):
            # positive phrases
            if (not map_keywords_id_keywords.has_key(keyword_group_id)):
                logger.error(
                    u'No keywords with id \'{0}\' for landing \'{1}\'. Skipping.'.format(keyword_group_id, landing_id))
                continue
            keywords_group = map_keywords_id_keywords.get(keyword_group_id)
            for phase in keywords_group.get(ALL_PHRASES_FIELD):
                type, text = get_phrase_type_and_phrase(phase)
                positive_one = {
                    'xsi_type': 'BiddableAdGroupCriterion',
                    'adGroupId': ad_group_id,
                    'criterion': {
                        'xsi_type': 'Keyword',
                        'matchType': type,
                        'text': text
                    },
                }
                # adding cpc_bid if exists in keyword_group
                if keywords_group.has_key('cpc_bid'):
                    positive_one.update(
                        {'biddingStrategyConfiguration': {
                            'bids': [
                                {
                                    'xsi_type': 'CpcBid',
                                    'bid': {
                                        'microAmount': int(float(keywords_group.get('cpc_bid')) * 1000000)
                                    }
                                }
                            ]
                        }}
                    )

                operations.append({
                    'operator': 'ADD',
                    'operand': positive_one
                })
                if len(operations) > 500:
                    ad_group_criterion_service.mutate(operations)['value']
                    operations = []

            for phrase in keywords_group.get('minus_phrases'):
                negative_one = {
                    'xsi_type': 'NegativeAdGroupCriterion',
                    'adGroupId': ad_group_id,
                    'criterion': {
                        'xsi_type': 'Keyword',
                        'matchType': 'EXACT',
                        'text': phrase
                    }
                }
                operations.append({
                    'operator': 'ADD',
                    'operand': negative_one
                })
                if len(operations) > 500:
                    ad_group_criterion_service.mutate(operations)['value']
                    operations = []


            if operations:
                ad_group_criterion_service.mutate(operations)['value']
                operations = []

    return map_landing_id_adgroup_id


def create_all(params, file_out):
    budget_id = None
    if params['budget']['budget_id'] != 0:
        budget_id = create_budget(params['budget']['amount'])
        params['budget']['budget_id'] = budget_id
    else:
        budget_id = params['budget']['budget_id']
    campaign_id = create_new_campaign(params, budget_id)
    json.dumps(file_out, params)

def urlencode_curly(params):
    right = 'RIGHTCURLYBRACE7591736'
    left = 'LEFTCURLYBRACE7591736'
    for k, v in params.items():
        params[k] = v.replace('{', left).replace('}', right)
    return urllib.urlencode(params).replace(left, '{').replace(right, '}')

def generate_landing_urls(params, params_dict, campaign_id, map_landing_adgroup):
    res = dict()
    for landing in params['landings']:
        landing_dict = flatten(landing)

        # setting landing_params
        if landing.has_key('params'):
            landing_params = landing['params']
        else:
            landing_params = dict()
            landing['params'] = landing_params

        landing_id = landing['id']
        set_default_in_place_if_absent(landing_params, 'utm_campaign', u'${campaign.name}')
        set_default_in_place_if_absent(landing_params, 'utm_source', u'${campaign.channel}')
        set_default_in_place_if_absent(landing_params, 'utm_medium', u'${campaign.channel_subtype}')
        set_default_in_place_if_absent(landing_params, 'utm_term', u'{keyword}')
        set_default_in_place_if_absent(landing_params, 'utm_content', u'{placement}')
        set_default_in_place_if_absent(landing_params, 'from', u'${campaign.channel}')
        landing_params['cd_g_campaign_id'] = campaign_id
        landing_params['cd_g_adgroup_id'] = map_landing_adgroup.get(landing_id)
        # resolving params
        new_dict = params_dict.copy()
        new_dict.update(landing_dict)
        resolve_params(landing, new_dict)
        if (res.has_key(landing_id)):
            raise Exception(u'Duplicate landing ids = [{0}]'.format(landing_id))

        encoded_params = urlencode_curly(landing_params)
        finalUrl = landing['base_url'] + '?' + encoded_params
        landing[FINAL_URL_FIELD] = finalUrl
        if not landing.has_key(DISPLAY_URL_FIELD):
            parsed_uri = urlparse.urlparse(finalUrl)
            landing[DISPLAY_URL_FIELD] = parsed_uri.netloc

        res[landing_id] = landing

    return res


def set_default_in_place_if_absent(landing_params, parameter, default):
    if not landing_params.has_key(parameter):
        landing_params[parameter] = default


def flatten(params, prefix='', delim='.'):
    items = []
    for k, v in params.items():
        new_key = prefix + delim + k if prefix else k
        if isinstance(v, collections.MutableMapping):
            items.extend(flatten(v, new_key, delim).items())
        else:
            items.append((new_key, v))
    return dict(items)


class MyTemplate(Template):
    idpattern = r'[a-z][_a-z0-9]*(\.[a-z][_a-z0-9]*)*'


def resolve_params(params, params_dict):
    if isinstance(params, list):
        for i in range(0, len(params)):
            params[i] = resolve_params(params[i], params_dict)
    elif isinstance(params, dict):
        for key, value in params.iteritems():
            params[key] = resolve_params(value, params_dict)
    else:
        if isinstance(params, basestring):
            return MyTemplate(params).safe_substitute(params_dict)
        else:
            return params
    return params


def unflat_params(params):
    return params


def split_path(str):
    return str.split('.')


class GoogleBanner(object):
    def __init__(self, title, description1, description2, url, display_url):
        self.title = title
        self.description1 = description1
        self.description2 = description2
        self.url = url
        self.display_url = display_url


def generate_banners(params, params_dict, map_id_to_landing):
    res = dict()
    if not params.has_key('banners'):
        raise Exception(u'No banners set in config. Use keyword \'banners\' to specify set of banners.')
    for banner_params in params['banners']:
        if not banner_params.has_key('landings'):
            raise Exception(u'No landings set for banner with title {0}'.format(banner_params.get('title')))
        title = banner_params.get('title')
        descr1 = banner_params.get('description1')
        descr2 = banner_params.get('description2')
        for landing_id in banner_params['landings']:
            if not map_id_to_landing.has_key(landing_id):
                raise Exception(u'No landing with id = {0} for'.format(landing_id))

            landing = map_id_to_landing.get(landing_id)
            if not res.has_key(landing_id):
                res[landing_id] = [] #creating new array for banners for this landing
            res.get(landing_id).append(GoogleBanner(title, descr1, descr2, landing.get(FINAL_URL_FIELD), landing.get(DISPLAY_URL_FIELD)))
    return res


def generate_params_file(params_file):
    out_fos = open(params_file, mode='w')
    data = {
        'budget': {
            'budget_id': 441253485,
            'amount': 5000,  # budget will be ignored if budget id is none zero, otherwise new budget will be created
        },
        'campaign': {
            'name': u'Тестовая рекламная кампания',
            'start_date': datetime.date.today().strftime('%Y%m%d'), #can be missing 20150913
            'end_date': (datetime.date.today() + datetime.timedelta(days=7)).strftime('%Y%m%d'), #can be missing
            'channel': 'GOOGLE',  # possible channels GOOGLE, FACEBOOK
            'channel_subtype': 'SEARCH_NETWORK',
            # possible subtypes for GOOGLE (GOOGLE_SEARCH, SEARCH_NETWORK, CONTENT_NETWORK), for FACEBOOK (IN_FEED, RIGHT)
            'labels': ['experiment'], #currently not supported
            'cpc_bid': 0.3,
        },
        'landings': [
            {
                'id': 'ls1',
                'base_url': u'https://www.yandex.ru/set/brand',
                'params': {
                    'utm_campaign': u'${campaign.name}',  # can be ignored - default will be generated
                    'utm_source': u'${campaign.channel}',  # can be ignored - default will be generated
                    'utm_medium': u'${campaign.channel_subtype}',  # can be ignored - default will be generated
                },
                'keywords': ['kw1']
            },
            {
                'id': 'ls2',
                'base_url': u'https://www.yandex.ru/set/brand_yandex',
                'keywords': ['kw1']
            },
        ],
        'banners': [  #FIXME change banners to ads
            {
                'title': u'Заголовок',
                'description1': u'первая строка объявления',
                'description2': u'вторая строка объявления',
                'landings': ['ls1', 'ls2']
            },
            {
                'title': u'Только для ls2',
                'description1': u'первая строка объявления',
                'description2': u'вторая строка объявления',
                'landings': ['ls2']
            }
        ],
        'keywords': [
            {
                'id': 'kw1',
                'phrases': ['phrase number 1', 'yandex ceviri'],
                'keywords_file': '/Users/aalogachev/keywords.txt', # can be missing
                'minus_phrases': ['google'],
                'cpc_bid': 0.4,  # can be ignored - then cpc_bid from campaign will be used
            },
        ],
    }
    out_fos.write(json.dumps(data, ensure_ascii=False))
    return data


def update_adgroup_with_banners(client, params, params_dict, ad_group_id, banners):
    # Initialize appropriate service.
    ad_group_ad_service = client.GetService('AdGroupAdService', version='v201506')

    # Construct operations for adding text ad object and add to an ad group.
    operations = []

    for banner in banners:
        assert isinstance(banner, GoogleBanner)
        add_banner_op = {
            'operator': 'ADD',
            'operand': {
                'xsi_type': 'AdGroupAd',
                'adGroupId': ad_group_id,
                'ad': {
                    'xsi_type': 'TextAd',
                    'finalUrls': [banner.url],
                    'displayUrl': banner.display_url,
                    'description1': banner.description1,
                    'description2': banner.description2,
                    'headline': banner.title
                },
                'status': 'ENABLED'
            }
        }
        operations.append(add_banner_op)

    ads = ad_group_ad_service.mutate(operations)['value']
    return


def load_keywords(params):
    res = dict()
    if not params.has_key('keywords'): raise Exception(u'No keywords filled. Use \'keywords\' group in json root.')
    keywords_params = params['keywords']
    for keywords_group_params in keywords_params:
        if not keywords_group_params.has_key('id'): raise Exception(u'No id set for keywords group')
        kw_id = keywords_group_params['id']
        if (res.has_key(kw_id)):
            raise Exception(u'Duplicate keyword ids = [{0}]'.format(kw_id))
        all_phrases = keywords_group_params.get('phrases', [])
        if keywords_group_params.has_key('keywords_file'):
            # loading other phrases from file
            for line in open(keywords_group_params.get('keywords_file'), mode='r'):
                all_phrases.append(line.strip())
        keywords_group_params[ALL_PHRASES_FIELD] = all_phrases
        res[kw_id] = keywords_group_params
    return res

def load_task_from_file(task_filename):
    with open(task_filename) as data_file:
        res = json.load(data_file)
    return res

if __name__ == '__main__':
    logging.basicConfig(format='%(asctime)s : %(levelname)s : %(message)s', level=logging.DEBUG)

    adwords_client = ga_camp.get_client();
    task_filename = os.path.expanduser('~/ads.json')
    #data = generate_params_file(task_filename)
    data = load_task_from_file(task_filename)

    # getting data and resolving parametes in it
    data_dict = flatten(data, prefix='')
    resolved = resolve_params(data, data_dict)

    # FIXME add check for budget keyword
    budget_data = data.get('budget')
    if budget_data.has_key('budget_id') and budget_data.get('budget_id') != 0:
        budget_id = budget_data.get('budget_id')
    else:
        budget_id = create_budget(adwords_client, int(float(budget_data['amount']) * 1000000))
        logger.info(u'Budget with id = {0} created. Please use this id in later campaigns for the same budget.'.format(budget_id))

    # almost done
    logger.info(u'Creating new campaign')
    campaign_id = create_new_campaign(adwords_client, resolved, budget_id)

    logger.info(u'Loading keywords')
    map_keywords_id_keywords = load_keywords(resolved)

    logger.info(u'Creating adgroups')
    map_landing_id_adgroup_id = create_adgroups(adwords_client, resolved, data_dict, campaign_id,
                                                map_keywords_id_keywords)
    logger.info(u'Generating landing urls')
    map_landing_id_to_landing = generate_landing_urls(resolved, data_dict, campaign_id, map_landing_id_adgroup_id)

    logger.info(u'Generating banners')
    map_landing_id_banners = generate_banners(resolved, data_dict, map_landing_id_to_landing)

    logger.info(u'Creating banners in adgroups')
    for landing_id, adgroup_id in map_landing_id_adgroup_id.iteritems():
        if not map_landing_id_banners.has_key(landing_id):
            logger.warn(u'No banners for landing with id={0}. Ignoring.'.format(landing_id))
            # TODO add removal of adgroup for this landing?
            continue
        banners = map_landing_id_banners.get(landing_id)
        # done
        update_adgroup_with_banners(adwords_client, resolved, data_dict, adgroup_id, banners)
    logger.info(u'Done')
