#!/usr/bin/env python
#  -*- coding: utf-8 -*-
__author__ = 'aalogachev'

import requests
import json
import logging
import ConfigParser
import pyjsonrpc
import os
from ru.yandex import utils

logging.basicConfig(format='%(asctime)s : %(levelname)s : %(message)s', level=logging.ERROR)

logger = logging.getLogger('statistics.yandex_stat')

config = ConfigParser.SafeConfigParser()
config.readfp(open(os.path.join(utils.get_project_path(),'config.json')))
section = config.defaults()['active_section']
logger.debug('Using config section =' + section)
work_dir = config.get(section=section, option='work_dir')
logger.debug("Using work dir = " + work_dir)
queries_file = config.get(section, 'queries_file')
stat_file = config.get(section, 'yandex_stat_file')

#parameters for getting word statistics
default_params = {'lang':'rus', 'format':'json'}
#advq_stat_url = 'http://back.advq.yandex.ru/advq/search'
#help for advq http://back.advq.yandex.ru/advq/help
advq_stat_url = config.get(section, 'advq_stat_url')


http_client = pyjsonrpc.HttpClient(
    url = "http://whale-http.yandex.net",
)
#params = json.dump()
http_client.ClicksDistribution(phrases=['yandex','alpha'])

#getting statistics
def get_sentence_stat(query):
    params = {'words': query}
    res = requests.get(advq_stat_url, params=dict(params, **default_params))
    logger.debug('stat URL was called =' + res.url)
    result = json.loads(res.text)
    logger.debug('response result = %s', result)
    total_count = result['requests'][0]['stat']['total_count']
    logger.info('Total count for query [%s] = %s', query, total_count)
    return total_count

outstat = open(stat_file, mode='w')
already_queried = set()
total_queried = 0
count = 0
for line in open(queries_file):
    query = line.rstrip()
    if (query not in already_queried):
        #outstat.write(str(get_sentence_stat(query)) + '\t' + query + '\n')
        already_queried.add(query)
        total_queried+=1
    count+=1
    if count%100 == 0: print "Lines processed = " + str(count) + " queried = " + str (total_queried)


