#!/usr/bin/env python
# -*- coding: utf-8 -*-

import smtplib
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.utils import COMMASPACE
from os.path import basename
import types


def mime_html(content):
    if isinstance(content, unicode):
        content = content.encode('utf-8')
    return MIMEText(content, 'html', 'utf-8')


def mime_attachment(filename):
    with open(filename, 'rb') as fp:
        data = fp.read()
    bn = basename(filename)
    part = MIMEApplication(data, Name=bn)
    part['Content-Disposition'] = 'attachment; filename={}'.format(bn)
    return part


def sure_list(x):
    if isinstance(x, types.StringTypes):
        return [x]
    return x


def send_email(from_, to, subject, html, files,
               smtp_server='outbound-relay.yandex.net'):
    """
    Send html email with attachments.
    """
    to = sure_list(to)
    files = sure_list(files)

    msg = MIMEMultipart()
    msg['Subject'] = subject
    msg['From'] = from_
    msg['To'] = COMMASPACE.join(to)

    msg.attach(mime_html(html))
    for a in files:
        msg.attach(mime_attachment(a))

    s = smtplib.SMTP(smtp_server)
    s.sendmail(from_, to, msg.as_string())
    s.quit()
