import logging, io, sys
from googleads.adwords import AdWordsClient

client = AdWordsClient.LoadFromStorage('googleads.yaml')
report_downloader = client.GetReportDownloader(version='v201601')
campaign_service = client.GetService('CampaignService', version='v201601')


def awql_report(customer_id, query, frmt='TSV', skip_report_header=True,
                skip_column_header=False, skip_report_summary=True, include_zero_impressions=False):
    client.SetClientCustomerId(customer_id)
    data = report_downloader.DownloadReportAsStringWithAwql(
        query,
        frmt,
        skip_report_header=skip_report_header,
        skip_column_header=skip_column_header,
        skip_report_summary=skip_report_summary,
        include_zero_impressions=include_zero_impressions
    )

    return data


def rus_date_to_adw_date(date):
    return date.replace('-', '')


def campaigns_report(customer_id, date):
    report_query = (
        'SELECT CampaignId, CampaignName, Impressions, Clicks, Cost \
         FROM CAMPAIGN_PERFORMANCE_REPORT \
         DURING {0},{0}'.format(rus_date_to_adw_date(date))
    )

    return awql_report(customer_id, report_query)


def destination_url_report(customer_id, date):
    report_query = (
        'SELECT EffectiveTrackingUrlTemplate, Impressions, Clicks, Cost \
         FROM FINAL_URL_REPORT \
         DURING {0},{0}'.format(rus_date_to_adw_date(date))
    )

    return awql_report(customer_id, report_query)


def ad_performance_report(customer_id, date):
    report_query = (
        'SELECT CreativeFinalUrls, Impressions, Clicks, Cost \
         FROM AD_PERFORMANCE_REPORT \
         DURING {0},{0}'.format(rus_date_to_adw_date(date))
    )

    return awql_report(customer_id, report_query)


def ad_performance_report2(customer_id, date_literal):
    report_query = (
        'SELECT Date \
         FROM AD_PERFORMANCE_REPORT \
         DURING {0}'.format(date_literal)
    )

    return awql_report(customer_id, report_query)


# if __name__ == '__main__':
#     print('Simple Adwords API script. Please use as a library')
#     print(set(sorted(ad_performance_report2(6022164922, 'LAST_WEEK_SUN_SAT').split('\n'))))
