#!/usr/bin/env python2.7
import datetime
import json


def days_list(days):
    return [datetime.datetime.strptime(x, '%Y%m%d').strftime('%Y-%m-%d') for x in days.split(',')]


def days_range(start, stop, increment=1):
    start_date = datetime.datetime.strptime(start, '%Y%m%d')
    stop_date = datetime.datetime.strptime(stop, '%Y%m%d')
    days_count = int((stop_date - start_date).days) + 1
    day_list = [(start_date + datetime.timedelta(days=x)).strftime('%Y-%m-%d') for x in range(0, days_count, increment)]
    return day_list


def json_print(data):
    try:
        print(json_dump(data).decode('unicode_escape'))
    except UnicodeEncodeError:
        print(json_dump(data))


def json_dump(data):
    return json.dumps(data, sort_keys=True, indent=2)


def json_print_only_error(response):
    json_print_only_error_content(response.content)


def json_print_only_error_content(content):
    try:
        data = json.loads(content)
        if 'data' not in data:
            json_print(data)
    except ValueError:
        print(content)


def format_digit(d, d_name):
    d_value = d["{}s".format(d_name)]
    return '' if d_value == 0 else '1 {} '.format(d_name) if d_value == 1 else '{} {}s '.format(d_value, d_name)


def strfdelta(tdelta):
    d = {"days": tdelta.days}
    d["hours"], rem = divmod(tdelta.seconds, 60*60)
    d["minutes"], d["seconds"] = divmod(rem, 60)
    return format_digit(d, 'day') + format_digit(d, 'hour') + format_digit(d, 'minute')


def safe_divide(a, b):
    return (a / b) if b != 0 else None
