from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)

from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import requests
import numpy as np
import datetime

def parse_query(x, y):
        if y == 'af_search' or y == 'first_search_event':
            for par in x.replace('"', '').split(','):
                if 'af_search_string' in par:
                    return par.split(':')[1].replace('}', '')
def parse_revenue(x, y):
        if y == 'af_search' or y == 'first_search_event':
            for par in x.replace('"', '').split(','):
                if 'af_revenue' in par:
                    return par.split(':')[1].replace('}', '')
def parse_currency(x, y):
        if y == 'af_search' or y == 'first_search_event':
            for par in x.replace('"', '').split(','):
                if 'af_currency' in par:
                    return par.split(':')[1].replace('}', '')
def rename_event(x):
    if 'search' in str(x):
        return 'search'
    else:
        return x
def media(x):
    if x == None:
        return 'Unknown'
    elif str(x).lower() == 'null' or str(x).lower() == 'organic':
        return 'Organic'
    elif 'ya_' in str(x).lower():
        return 'Portal'
    elif '_int' in str(x).lower():
        return 'Paid'
    else:
        return 'Other'
def media1(x):
    if x == None:
        return 'Unknown'
    elif str(x).lower() == 'null' or str(x).lower() == 'organic':
        return 'Organic'
    else:
        return str(x).lower()
def week_start(x):
    try:
        return str(datetime.datetime.strptime(str(x), '%Y-%m-%d') - datetime.timedelta(days=datetime.datetime.strptime(str(x), '%Y-%m-%d').weekday())).split(' ')[0]
    except:
        return None
def month_start(x):
    try:
        return str(datetime.datetime.strptime(str(x), '%Y-%m-%d').replace(day=1)).split(' ')[0]
    except:
        return None
def install_day(x,y):
    if str(x) == str(y):
        return 'New'
    else:
        return 'Old'
def install_month(x,y):
    if str(x) == str(y):
        return 'New'
    else:
        return 'Old'
def install_week(x,y):
    if str(x) == str(y):
        return 'New'
    else:
        return 'Old'
def d_delta(x, y):
    try:
        t = datetime.datetime.strptime(str(x), '%Y-%m-%d') - datetime.datetime.strptime(str(y), '%Y-%m-%d')
        return t.days
    except:
        return 0
def w_delta(x, y):
    try:
        t = datetime.datetime.strptime(str(x), '%Y-%m-%d') - datetime.datetime.strptime(str(y), '%Y-%m-%d')
        return int(t.days/7)
    except:
        return 0
def m_delta(x, y):
    try:
        return (datetime.datetime.strptime(str(x), '%Y-%m-%d').year - datetime.datetime.strptime(str(y), '%Y-%m-%d').year)*12 + datetime.datetime.strptime(str(x), '%Y-%m-%d').month - datetime.datetime.strptime(str(y), '%Y-%m-%d').month
    except:
        return 0
def get_app_name(x):
    if str(x) == 'ru.yandex.searchplugin':
        return 'Search App Android'
    else:
        return 'Search App IOS'
enddate = datetime.datetime.now() - datetime.timedelta(days=1)
startdate = datetime.datetime.now() - datetime.timedelta(days=89)
enddate = str(enddate).split(' ')[0]
startdate = str(startdate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        dates='{%s}' % (enddate)
    )
)
job = cluster.job()
uuid_adi = job.table('statbox/extdata-apps-flyer-log/@dates')
uuid_adi = uuid_adi.filter(nf.custom(lambda x: x != '' and x != None, 'appsflyer_device_id'), nf.custom(lambda x: x != '' and x != None, 'customer_user_id'))
uuid_adi = uuid_adi.groupby('appsflyer_device_id', 'customer_user_id').aggregate(some = na.count()).project('appsflyer_device_id', uuid = 'customer_user_id').filter(nf.custom(lambda x: x != None and x != '' and x != 'null', 'uuid'))
uuid_adi = uuid_adi.put('$job_root/appsflyer_dash/appsflyer_device_id_dist', append=True)
job.run()
job = cluster.job()
uuid_adi = job.table('$job_root/appsflyer_dash/appsflyer_device_id_dist')
uuid_adi = uuid_adi.groupby('appsflyer_device_id', 'uuid').aggregate(some = na.count()).project('appsflyer_device_id', 'uuid')
uuid_adi = uuid_adi.put('$job_root/appsflyer_dash/appsflyer_device_id_dist')
job.run()
