# coding: utf-8
import datetime
from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)
from qb2.api.v1 import (
    filters as sf,
    QB2,
    extractors as se,
    resources as sr
)

end_date = datetime.datetime.now() - datetime.timedelta(days=1)
start_date = end_date - datetime.timedelta(days=30)
end_date_str = str(end_date).split(' ')[0]
start_date_str = str(start_date).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
templates=dict(
    job_root='home/turkey-analytics/ktereshin',
    dates='{%s..%s}' % (start_date_str, end_date_str)
)
)

job = cluster.job()
users = job.table('statbox/metrika-mobile-log/@dates') \
    .filter(
        nf.or_(
            nf.custom(lambda x: not x in [None, ''], 'ADVID'),
            nf.custom(lambda x: not x in [None, ''], 'OriginalDeviceID')
        ),
        nf.custom(lambda x: str(x).lower() in ['android', 'ios'], 'AppPlatform'),
        nf.custom(lambda x: x == 'SESSION_FOREGROUND', 'SessionType'),
        nf.custom(lambda x: x in ['10321', '42989', '106400', '19531', '19534', '619001'], 'APIKey'),
    ) \
    .groupby(
        'APIKey',
        'ADVID',
        'OriginalDeviceID'
    ) \
    .aggregate(
        hits = na.count(),
    ) \
    .put('$job_root/RESEARCH-2366/ids')
job.run()
