from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)
from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import numpy as np
import random
startdate = datetime.datetime.now() - datetime.timedelta(days=1)
startdate = str(startdate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        dates='{%s}' % (startdate)
    )
)

def act(x):
    if str(x) == 'SESSION_FOREGROUND':
        return 1
    else:
        return 0
job = cluster.job()
metrika = job.table('statbox/metrika-mobile-log/@dates')
mekrika_data = metrika.qb2(
    log='metrika-mobile-log',
    fields = ['date','uuid', 'device_id', 'session_type'],
    filters = [sf.custom(lambda x: x in [10321, 42989], 'api_key'),
        sf.custom(lambda x: not ('push' in str(x)), 'event_name'),
    sf.defined('device_id')]
)
mekrika_data = mekrika_data.groupby('date','uuid', 'device_id', 'session_type').aggregate(events = na.count()).project('date','uuid', 'device_id', active=ne.custom(act, 'session_type'))
mekrika_data = mekrika_data.groupby('date', 'device_id', 'uuid').aggregate(active = na.sum('active'))
mekrika_data = mekrika_data.put('$job_root/push_sample/users_all_event', append=True)
job.run()
