import pandas as pd, urllib, urllib2, datetime, requests, numpy as np, time, json, re, warnings
from itertools import chain, product
warnings.filterwarnings('ignore')
def get_stat_data(url_):
    headers = {
        'User-Agent': 'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)',
        'StatRobotUser': 'robot_ktereshin',
        'StatRobotPassword': '3en5cayAppeif6l'
    }
    url_ = url_ + '&_type=json'
    req = urllib2.Request(url_, None, headers)
    res = urllib2.urlopen(req)
    result = res.read()
    return result

def dataframe_from_dict(dict_, fields):
    df = pd.DataFrame(dict_['values'], index=range(len(dict_['values'])))[fields]
    return df.sort_values(by='fielddate')

def calc_rolling_metrics(df):
    df['shows_rolling_sum'] = pd.rolling_sum(df['shows'], 7).fillna(0)
    df['clicks_rolling_sum'] = pd.rolling_sum(df['clicks'], 7).fillna(0)
    df['installs_rolling_sum'] = pd.rolling_sum(df['trueinstalls'], 7).fillna(0)
    df['clicks_rate_rolling_sum'] = df['clicks_rolling_sum'] / df['shows_rolling_sum']
    df['installs_rate_rolling_sum'] = df['installs_rolling_sum'] / df['shows_rolling_sum']
    df['clicks_rate'] = df['clicks'] / df['shows']
    df['installs_rate'] = df['trueinstalls'] / df['shows']
    return df

def calc_w2w_metrics(df, metrics_w2w):
    for metric in metrics_w2w:
        w2w = (np.array(df[metric][14:]) / np.array(df[metric][7:-7])) - 1
        diff = (np.array(df[metric][14:]) - np.array(df[metric][7:-7]))
        df[metric+'_w2w'] = [0]*14 + list(w2w)
        df[metric+'_diff'] = [0]*14 + list(diff)
    return df

def get_unique_dimention_value(df, fields):
    result_list = []
    for field in sorted(fields):
        if 'override_by_dictionary' in field:
            result_list.append(list(df[field].unique()))
    return result_list

def combine_all_dataframe(urls):
    result = pd.DataFrame()
    data = dataframe_from_dict(
        json.loads(get_stat_data(url)), fields
    )
    field_list = get_unique_dimention_value(data, fields)
    for dim in product(*chain(field_list)):
        temp = data[
            (data['distr_obj_override_by_dictionary'] == dim[0])
            & (data['os_override_by_dictionary'] == dim[1])
            & (data['product_override_by_dictionary'] == dim[2])
            & (data['region_override_by_dictionary'] == dim[3])
        ]
        if temp.shape[0] > 14:
            temp = calc_w2w_metrics(calc_rolling_metrics(temp), metrics_w2w)
            result = pd.concat([result, temp])
    return result.fillna(0)

url = 'https://stat.yandex-team.ru/Distribution/Others/AtomBanners/AtomDistribution?scale=d&_incl_fields=clicksrate&_incl_fields=shows&_incl_fields=trueinstalls&_incl_fields=trueinstallsrate&browser=_total_&candidate=3&element=0&lang=1&os=Android&os=Windows&os=iOS&product=_allextensions_&product=search&product=browser&product=browserlite&service=4&testid=_total_&referer=_total_&region=by&region=kz&region=ru&region=tr&region=ua&distr_obj=_total_&distr_obj=default_search&distr_obj=distr_stripe&distr_obj=mobilefooter&distr_obj=portal_popup&distr_obj=promolib&distr_obj=smart-banner&distr_obj=smart_banner&distr_obj=teaser&_period_distance=400'

fields = [
    'fielddate',
    'region_override_by_dictionary',
    'os_override_by_dictionary',
    'product_override_by_dictionary',
    'distr_obj_override_by_dictionary',
    'shows',
    'clicks',
    'trueinstalls'
]
metrics_w2w = [
    'shows_rolling_sum',
    'clicks_rolling_sum',
    'installs_rolling_sum',
    'clicks_rate_rolling_sum',
    'installs_rate_rolling_sum'
]
result =  combine_all_dataframe(url)
csv_data = re.sub('\n$', '', result.fillna('unknown').drop_duplicates().to_csv(sep=';', index=False, encoding = 'utf-8'))
r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'StatRobotUser': 'robot_ktereshin', 'StatRobotPassword': '3en5cayAppeif6l'},
    data={
        'name': 'Distribution/ktereshin/atom/atom_w2w',
        'scale': 'd',
        'data': csv_data,
    },
)
