from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)
from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import numpy as np
import random
import operator
import re
from functools import partial
startdate = datetime.datetime.now() - datetime.timedelta(days=1)
startdate = str(startdate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        dates='{%s}' % (startdate)
    )
)

job = cluster.job()
metrika = job.table('statbox/metrika-mobile-log/@dates')
mekrika_data = metrika.qb2(
    log='metrika-mobile-log',
    fields = ['date','uuid', 'device_id', 'api_key', 'event_name'],
    filters = [sf.custom(lambda x: x == 'data_refresh_widget_event', 'event_name'),
               sf.custom(lambda x: x in [10321], 'api_key')]
)
mekrika_data = mekrika_data.groupby('date', 'device_id').aggregate(events = na.count())
mekrika_data = mekrika_data.put('$job_root/push_sample/hate_metric', append=True)
job.run()
