from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)

from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import requests
import numpy as np
import datetime

def d_delta(x, y):
    try:
        t = datetime.datetime.strptime(str(x), '%Y-%m-%d %H:%M:%S') - datetime.datetime.strptime(str(y), '%Y-%m-%d %H:%M:%S')
        return t.days
    except:
        return None
enddate = datetime.datetime.now() - datetime.timedelta(days=1)
startdate = datetime.datetime.now() - datetime.timedelta(days=8)
enddate = str(enddate).split(' ')[0]
startdate = str(startdate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        dates='{%s..%s}' % (startdate, enddate)
    )
)
job = cluster.job()
appsfluer = job.table('statbox/extdata-apps-flyer-log/@dates')
appsfluer = appsfluer.filter(nf.custom(lambda x: x != '' and x != None, 'appsflyer_device_id'),nf.custom(lambda x: x != '' and x != None, 'app_id'),nf.custom(lambda x: x >= startdate, 'install_time'),nf.custom(lambda x: x <= enddate, 'install_time'))
install_t = appsfluer.project('appsflyer_device_id','app_id', 'app_version', 'media_source', 'platform', install_time = ne.custom(lambda x: str(x).split(' ')[0], 'install_time'))
install_t = install_t.groupby('appsflyer_device_id','app_id', 'app_version', 'media_source', 'platform','install_time').aggregate(some = na.count()).project('appsflyer_device_id','app_id', 'media_source', 'app_version', 'platform','install_time')
download_t = appsfluer.project('appsflyer_device_id','app_id','media_source', 'platform', download_time = ne.custom(lambda x: str(x).split(' ')[0], 'download_time'))
download_t = download_t.groupby('appsflyer_device_id','download_time').aggregate(some = na.count()).project('appsflyer_device_id','download_time')
appsfluer = install_t.join(download_t, by='appsflyer_device_id', type='full')
uuid_adi = job.table('statbox/extdata-apps-flyer-log/@dates')
uuid_adi = uuid_adi.filter(nf.custom(lambda x: x != '' and x != None, 'appsflyer_device_id'), nf.custom(lambda x: x != '' and x != None, 'customer_user_id'))
uuid_adi = uuid_adi.groupby('appsflyer_device_id', 'customer_user_id').aggregate(some = na.count()).project('appsflyer_device_id', uuid = 'customer_user_id').filter(nf.custom(lambda x: x != None and x != '' and x != 'null', 'uuid'))
appsfluer = appsfluer.join(uuid_adi, by='appsflyer_device_id', type='left')
appsfluer = appsfluer.put('$job_root/installs/appsflyer/install')
job.run()

def media(x):
    if x == None:
        return 'Unknown'
    elif str(x).lower() == 'null' or str(x).lower() == 'organic':
        return 'Organic'
    elif 'ya_' in str(x).lower() or 'yandex' in str(x).lower() or 'switch' in str(x).lower():
        return 'Portal'
    elif '_int' in str(x).lower() or 'cpa' in str(x).lower() or 'cpi' in str(x).lower() or 'cpc' in str(x).lower():
        return 'Paid'
    else:
        return 'Other'
def media1(x):
    if x == None:
        return 'Unknown'
    elif str(x).lower() == 'null' or str(x).lower() == 'organic':
        return 'Organic'
    else:
        return str(x).lower()
job = cluster.job()
appsflyer = job.table('$job_root/installs/appsflyer/install')
appsflyer = appsflyer.project(ne.all(), media_source_type=ne.custom(media,'media_source'), fielddate = 'install_time' )
appsflyer = appsflyer.project(ne.all(), media_source=ne.custom(media1,'media_source'))
appsflyer = appsflyer.groupby('fielddate', 'media_source_type', 'media_source', 'platform', 'app_id', 'appsflyer_device_id').aggregate(installs = na.count())
appsflyer = appsflyer.groupby('fielddate', 'media_source_type', 'media_source','platform', 'app_id').aggregate(installs = na.count())
appsflyer = appsflyer.put('$job_root/installs/appsflyer/install_aggr')
job.run()

result_data = appsflyer.read().as_dataframe().fillna(0)
res_data = pd.DataFrame(result_data.groupby(['fielddate', 'media_source_type', 'media_source','platform', 'app_id'])['installs'].sum()).reset_index()
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate', 'app_id','platform', 'media_source_type'])['installs'].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate', 'app_id','platform', 'media_source'])['installs'].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate', 'app_id','platform'])['installs'].sum()).reset_index())
res_data = res_data.fillna('total')
res_data = pd.DataFrame(res_data.groupby(['fielddate', 'media_source_type', 'media_source','platform', 'app_id'])['installs'].sum()).reset_index()
res_data = res_data[(res_data['fielddate'] >= startdate) & (res_data['fielddate'] <= str(datetime.datetime.now()).split(' ')[0])]

yaml_config = u'''
---
allow_recalculate: "0"
autovalues_enabled: "0"
dimensions:
  - fielddate: date
  - media_source_type: string
  - media_source: string
  - app_id: string
  - platform: string
measures:
  - installs: number
view_types:
  media_source_type:
    type: Selector
    default: total
  media_source:
    type: Selector
    default: total
  app_id:
    type: Selector
    default: ru.yandex.searchplugin
  platform:
    type: Selector
    default: android
aggregate_scales:
  - w_by_d_sum
  - m_by_d_sum
aggregate_uncomplete_period: "0"
'''
resp = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/config',
    headers={'StatRobotUser': 'robot_ktereshin', 'StatRobotPassword': '3en5cayAppeif6l'},
    data={
        'cube_config': yaml_config,'title': 'Installs (Appsflyer)', 'name': 'Distribution/ktereshin/installs/installs_appsflyer'
    },
)
import re
csv_data = re.sub('\n$', '', res_data.to_csv(sep=';', index=False))
r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'StatRobotUser': 'robot_ktereshin', 'StatRobotPassword': '3en5cayAppeif6l'},
    data={
        'name': 'Distribution/ktereshin/installs/installs_appsflyer',
        'scale': 'd',
        'data': csv_data,
    },
)
