from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)
from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import random
import numpy as np
startdate = datetime.datetime.now() - datetime.timedelta(days=4)
enddate = datetime.datetime.now() - datetime.timedelta(days=4)
startdate = str(startdate).split(' ')[0]
enddate = str(enddate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        tmp_root='home/turkey-analytics/ktereshin/temp',
        dates='{2016-04-01..2016-05-31}'
    )
)

def d_delta(x, y):
    try:
        t = datetime.datetime.strptime(str(x), '%Y-%m-%d') - datetime.datetime.strptime(str(y), '%Y-%m-%d')
        return t.days
    except:
        return None
def d_delta_install(x):
    try:
        t =  datetime.datetime.now() - datetime.datetime.strptime(str(x), '%Y-%m-%d')
        return t.days
    except:
        return None
def variant(x):
    return random.choice(['control','every_days_push','through_the_days_push'])
rightdate = datetime.datetime.now() - datetime.timedelta(days=7)
rightdate = str(rightdate).split(' ')[0]
job = cluster.job()
metrika = job.table('$job_root/installs/installs_uuid').filter(nf.custom(lambda x: x == 'Search_Mobile_App', 'project'),
                                                              nf.custom(lambda x: x == 'Android', 'platform'),
                                                               nf.custom(lambda x: x >= startdate, 'fielddate'),
                                                               nf.custom(lambda x: x <= enddate, 'fielddate'),
                                                                nf.custom(lambda x: x >= '4.65', 'app_version'),
                                                              ).project('device_id', 'fielddate', 'media_source', 'channel_type', 'media_source_type', 'uuid', 'app_version')
app_user = job.table('$job_root/push_sample/users_all_event').project('device_id', 'date', 'active')
metrika = metrika.join(app_user, by='device_id', type='left')
metrika = metrika.project(ne.all(), days_delta = ne.custom(d_delta, 'date', 'fielddate'),
                         days_since_install = ne.custom(d_delta_install, 'fielddate')).filter(nf.custom(lambda x: x >=0, 'days_delta')).sort('device_id', 'days_delta')
metrika = metrika.groupby('device_id','channel_type','fielddate','media_source','media_source_type','uuid', 'app_version').aggregate(active=na.sum('active'), days_delta = na.sum('days_delta'))\
.filter(nf.custom(lambda x: x <= 1, 'active'), nf.custom(lambda x: x == 0, 'days_delta'))
hw_id = job.table('$job_root/hw_id/dict')
metrika = metrika.join(hw_id, by='device_id', type='inner')
metrika = metrika.project(ne.all(), variant = ne.custom(variant, 'device_id'))
metrika = metrika.put('$job_root/push_sample/push_churn_sample_var1/samples', append=True)
job.run()
var = ['every_days_push','through_the_days_push']
for v in var:
    job = cluster.job()
    metrika = job.table('$job_root/push_sample/push_churn_sample_var1/samples').filter(nf.custom(lambda x: x == v, 'variant'),
                                                                                 nf.custom(lambda x: x == startdate, 'fielddate'))\
    .project('device_id', 'hw_id').put('$job_root/push_sample/push_churn_sample_var1/samples_variant/%s' % (v.lower().replace(' ', '_')), append=True)
    job.run()
