from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)

from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import numpy as np
import re
import requests
startdate = datetime.datetime.now() - datetime.timedelta(days=2)
enddate = startdate + datetime.timedelta(days=1)
startdate = str(startdate).split(' ')[0]
enddate = str(enddate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        dates='{2016-07-19}'
    )
)
def platform(x,y):
    if 'window' in str(x).lower() and (y==None or y==''):
        return 5746
    elif 'android' in str(x).lower() and (y==None or y==''):
        return 10321
    elif 'ios' in str(x).lower() and (y==None or y==''):
        return 42989
    else:
        return y
job = cluster.job()
search = job.table('$job_root/searches_money/searches_money_install_new_old')
search = search.project('media_source','project', 'media_source_type', 'channel_type', 'date', 'new_day', 'revenue', 'searches', 'browser', 'device_id', platform = ne.custom(lambda x: str(x).lower(),'platform')).filter(nf.custom(lambda x: x>0, 'searches'))
search = search.groupby('media_source','project','browser', 'platform', 'media_source_type', 'channel_type', 'date', 'new_day', 'device_id').aggregate(revenue = na.sum('revenue'), searches = na.sum('searches'))
search = search.groupby('media_source','project','browser', 'platform', 'media_source_type', 'channel_type', 'date', 'new_day').aggregate(revenue = na.sum('revenue'), searches = na.sum('searches'), users=na.count())
search = search.project('media_source','project','browser', 'platform', 'media_source_type', 'channel_type', 'new_day', 'searches', 'users', 'revenue', fielddate = 'date')
search = search.put('$job_root/searches_money/searches_money_install_new_old_by_days')
job.run()
result_data = search.read().as_dataframe().fillna(0)
res_data = pd.DataFrame(result_data.groupby(['media_source','project','browser', 'platform','fielddate','channel_type','media_source_type','new_day'])[['revenue', 'searches', 'users']].sum()).reset_index()
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type', 'media_source','media_source_type'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type', 'media_source','new_day'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type', 'media_source_type','new_day'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type', 'media_source'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type', 'new_day'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type', 'media_source_type'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project','browser', 'platform', 'channel_type'])[['revenue', 'searches', 'users']].sum()).reset_index())
res_data = res_data.fillna('total')
res_data = pd.DataFrame(res_data.groupby(['fielddate','project','browser', 'platform','channel_type','media_source_type','new_day', 'media_source'])[['revenue', 'searches', 'users']].mean()).reset_index()
def conv_money(x):
    try:
        return float(x)*30/1000000
    except:
        return 0
res_data['revenue'] = res_data['revenue'].apply(conv_money)
import requests
yaml_config = u'''
---
allow_recalculate: "0"
autovalues_enabled: "0"
dimensions:
  - fielddate: date
  - project: string
  - browser: string
  - platform: string
  - channel_type: string
  - media_source_type: string
  - media_source: string
  - new_day: string
measures:
  - users: number
  - searches: number
  - revenue	: number
view_types:
  project:
    type: Selector
    default: Search_Mobile_App
  browser:
    type: Selector
    default: SearchApp
  platform:
    type: Selector
    default: android
  channel_type:
    type: Selector
    default: Store_Installs
  media_source_type:
    type: Selector
    default: total
  media_source:
    type: Selector
    default: total
  new_day:
    type: Selector
    default: total
aggregate_uncomplete_period: "0"
'''
resp = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/config',
    headers={'StatRobotUser': 'robot_ktereshin', 'StatRobotPassword': '3en5cayAppeif6l'},
    data={
        'cube_config': yaml_config,
        'title': 'New Old Users',
        'name': 'Distribution/ktereshin/money_searches/search_money_new_old'
    },
)
dates = list(res_data['fielddate'].unique())
import re
for date in dates:
    r_data = res_data[res_data['fielddate'] == date]
    csv_data = re.sub('\n$', '', r_data.to_csv(sep=';', index=False))
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'StatRobotUser': 'robot_ktereshin', 'StatRobotPassword': '3en5cayAppeif6l'},
        data={
            'name': 'Distribution/ktereshin/money_searches/search_money_new_old',
            'scale': 'd',
            'data': csv_data,
        },
    )
