from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne,
    grouping as ng,
    clusters,
    files,
    statface,
    Record,
    Template,
    Path
)
from qb2.api.v1 import filters as sf
from qb2.api.v1 import QB2, extractors as se
import pandas as pd
import datetime
import numpy as np
import re
import requests
startdate = datetime.datetime.now() - datetime.timedelta(days=2)
enddate = startdate + datetime.timedelta(days=1)
startdate = str(startdate).split(' ')[0]
enddate = str(enddate).split(' ')[0]
cluster = clusters.Hahn(pool='mobile-research', token='a6575e1e15b0475fb8d8564beaa60f23').env(
    templates=dict(
        job_root='home/turkey-analytics/ktereshin',
        dates='{2016-02-24..2016-05-24}'
    )
)
def week_start(x):
    try:
        return str(datetime.datetime.strptime(str(x), '%Y-%m-%d') - datetime.timedelta(days=datetime.datetime.strptime(str(x), '%Y-%m-%d').weekday())).split(' ')[0]
    except:
        return None
def month_start(x):
    try:
        return str(datetime.datetime.strptime(str(x), '%Y-%m-%d').replace(day=1)).split(' ')[0]
    except:
        return None
job = cluster.job()
searches = job.table('$job_root/searches_money/searches_money').filter(nf.custom(lambda x: x != None and  x != '', 'uuid'))
searches = searches.project('channel','channel_type', 'uuid', 'revenue', 'searches', fielddate = ne.custom(month_start, 'date'), project = 'browser', platform = 'os_family')
searches = searches.groupby('uuid', 'fielddate').aggregate(revenue = na.sum('revenue'),searches = na.sum('searches'),channel = na.min('channel'),project = na.min('project'),channel_type = na.min('channel_type'),platform = na.min('platform'))
searches = searches.groupby('channel','project', 'channel_type', 'platform', 'fielddate').aggregate(revenue = na.sum('revenue'), searches = na.sum('searches'), users = na.count())
searches = searches.put('$job_root/searches_money/searches_money_for_graph_months')
job.run()
result_data = searches.read().as_dataframe().fillna(0)
res_data = pd.DataFrame(result_data.groupby(['fielddate','project','channel_type','channel','platform'])[['revenue','searches', 'users']].sum()).reset_index()
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project', 'channel_type','channel'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project', 'channel_type','platform'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project', 'channel','platform'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project', 'channel_type'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project', 'platform'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project', 'channel'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.append(pd.DataFrame(result_data.groupby(['fielddate','project'])[['revenue','searches', 'users']].sum()).reset_index())
res_data = res_data.fillna('total')
res_data = pd.DataFrame(res_data.groupby(['fielddate','project','channel_type','channel','platform'])[['revenue','searches', 'users']].sum()).reset_index()
def conv_money(x):
    try:
        return float(x)*30/1000000
    except:
        return 0
res_data['revenue'] = res_data['revenue'].apply(conv_money)
csv_data = re.sub('\n$', '', res_data.to_csv(sep=';', index=False))
r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'StatRobotUser': 'robot_ktereshin', 'StatRobotPassword': '3en5cayAppeif6l'},
    data={
        'name': 'Distribution/ktereshin/money_searches/money_searches_new',
        'scale': 'm',
        'data': csv_data,
    },
)
