#!/usr/bin/env python

def random_teams():
    # just a stub now
    teams = {
        '6012345678': dict(
        total={'installs': 700, 'active': 100, 'superactive': 15},
        week={'installs': 20, 'active': 80, 'superactive': 10}),
        '6087654321': dict(
        total={'installs': 600, 'active': 90, 'superactive': 10},
        week={'installs': 10, 'active': 30, 'superactive': 11}),
        '6044444441': dict(
        total={'installs': 500, 'active': 92, 'superactive': 12},
        week={'installs': 30, 'active': 200, 'superactive': 70}),
        '6022222221': dict(
        total={'installs': 500, 'active': 92, 'superactive': 12},
        week={'installs': 30, 'active': 200, 'superactive': 72})
    }

    import random
    import copy
    if True:
        for x in range(100):
            newteam = copy.deepcopy(random.choice(teams.values()))
            for d in newteam.itervalues():
                for k in d:
                    if d[k] > 5:
                        d[k] += random.randint(-5, 5)
            teams[str(random.randint(6000000000, 6099999999))] = newteam
    return teams

def set_scores(teams):
    for b, t in teams.iteritems():
        for s in ('week', 'total'): t[s]['score'] = t[s]['active'] + 2 * t[s]['superactive']
        t['url'] = b

def rank_teams(teams, wt):
    tlist = sorted(teams.itervalues(), key=(lambda team: team[wt]['score']), reverse=True)

    for r, t in enumerate(tlist):
        t[wt]['rank'] = r + 1
        first = max(0, r - 5)
        t[wt]['neighbors'] = [
                [neighbor['url'], neighbor[wt]['score']]
                for neighbor in tlist[first:first+10]]

    return tlist

def make_doc(url, data):
    return url, data

def team_list_doc(tlist, wlist):
    return make_doc('team_list', {
        'total': [[t['url'], t['total']['score']] for t in tlist],
        'week': [[t['url'], t['week']['score']] for t in wlist]
    })

def top20_doc(tlist, wlist):
    return make_doc('team_list', {
        'total': [[t['url'], t['total']['score']] for t in tlist[:20]],
        'week': [[t['url'], t['week']['score']] for t in wlist[:20]]
    })

def rank(teams):
    set_scores(teams)
    tlist = rank_teams(teams, 'total')
    wlist = rank_teams(teams, 'week')

    docs = [make_doc(t['url'], t) for t in tlist]
    docs.append(team_list_doc(tlist, wlist))
    docs.append(top20_doc(tlist, wlist))
    return docs

def main():
    teams = random_teams()
    set_scores(teams)
    tlist = rank_teams(teams, 'total')
    wlist = rank_teams(teams, 'week')

    docs = [make_doc(t['url'], t) for t in tlist]
    docs.append(team_list_doc(tlist, wlist))
    docs.append(top20_doc(tlist, wlist))

    from pprint import pprint
    pprint(docs)

    import saas
    for url, doc in docs:
        saas.production_storage[url] = doc

if __name__ == '__main__':
    main()
