import json
import requests
from collections import namedtuple
from UserDict import DictMixin

StorageConfig = namedtuple('StorageConfig', 'name id search_host index_host')

def json_to_utf8(j):
    return json.dumps(j, ensure_ascii=False).encode('utf-8')

class SaasStorage(DictMixin):
    def __init__(self, cfg):
        self.cfg = cfg

    def __getitem__(self, key):
        paramstr = ('ms=proto&hr=json&meta_search=first_found&normal_kv_report=yes'
            '&format=ysuggest&ysuggest_report_field=json&ysuggest_as_string=no'
            '&ysuggest_responses_only=yes')
        results = requests.get('http://{host}/{url}?{qs}'.format(
            host=self.cfg.search_host, url=self.cfg.name, qs=paramstr),
            params={'text': key}).json()
        if not results:
            raise KeyError(key)
        return results[0]

    def __setitem__(self, key, value):
        requests.post('http://{host}/service/{id}'.format(
            host=self.cfg.index_host, id=self.cfg.id),
            data=json_to_utf8({'action': 'modify', 'prefix': 0, 'docs': [
                    {'json': {'type': '#p', 'value': json_to_utf8(value)},
                    'options': {'charset': 'utf-8', 'mime_type': 'text/html'},
                    'url': {'value': key}}]}),
            headers={'Content-type': 'application/json'}).raise_for_status()

    def __delitem__(self, key):
        requests.post('http://{host}/service/{id}'.format(
            host=self.cfg.index_host, id=self.cfg.id),
            data=json_to_utf8({'action': 'delete', 'prefix': 0, 'docs': [
                    {
                    'options': {'charset': 'utf-8', 'mime_type': 'text/html'},
                    'url': {'value': key}}]}),
            headers={'Content-type': 'application/json'}).raise_for_status()


fenyastat_id = '32cfaf953f98fd9ce8912209bcc44f08'

prestable_config = StorageConfig(name='fenyastat', id=fenyastat_id,
        search_host='saas-searchproxy-prestable.yandex.net:17000',
        index_host='saas-indexerproxy-prestable.yandex.net:80')
production_config = StorageConfig(name='fenyastat', id=fenyastat_id,
        search_host='saas-searchproxy.yandex.net:17000',
        index_host='saas-indexerproxy.yandex.net:80')

prestable_storage = SaasStorage(prestable_config)
production_storage = SaasStorage(production_config)

class DebugStorage(object):
    def __setitem__(self, key, value):
        print 'DebugStorage:', key, '=>', value
