#!/usr/bin/env python

from count import Game, unparse_date
from saas import production_storage
import argparse
import cPickle
import time
import datetime
import os, sys

from fenestats import remake_map, compactify_export
import yt.wrapper as ytw

class DataFlow(object):
	def __init__(self, source, sink):
		self.source = source
		self.sink = sink

	def run(self):
		for o in self.source.unprocessed():
			for v in self.source.process(o):
				self.sink(v)


class Export5MinLogs(object):
	log_path = '//home/search-functionality/statbox/cs-http/export-access-log'
	interim_path = '//home/search-functionality/switch-tr/5min'

	def unprocessed(self):
		tables = ytw.list(self.log_path)
		if tables:
			tables.sort()
			tables.pop() # last table may be under a concurrent transaction
		return tables

	def process(self, table):
		interim = os.path.join(self.interim_path, table)
		remake_map(compactify_export,
				os.path.join(self.log_path, table), interim,
				sort_by=['ui', 'ts'], remove_source=True)
		return ytw.read_table(interim, raw=False)

def main():
	parser = argparse.ArgumentParser(
			description='Calculate and present statistics for FUNCTIONALITY-2004')
	parser.add_argument('save_dir', help='where to save state dumps')
	args = parser.parse_args()
	dumpfile = os.path.join(args.save_dir, 'latest')
	if os.path.exists(dumpfile):
		print 'loading dump', dumpfile
		game = cPickle.load(file(dumpfile))
	else:
		game = Game()
	flow = DataFlow(Export5MinLogs(), game.process_export_record)
	while True:
		flow.run()
		today = unparse_date(datetime.date.today())
		game.publish_scoreboard(today, production_storage)
		game.maybe_save(args.save_dir)
		time.sleep(100)

if __name__ == '__main__':
	main()
