#!/usr/bin/env python
# -*- encoding: utf-8 -*-

import operator
from collections import defaultdict

class Query(object):
    def __init__(self, group, q):
        self.group = group
        self.words = q.strip().split()
    def __unicode__(self):
        return ' '.join(self.words)

def minus(queries):
    """
    >>> sorted(minus([('g1', 'auto'), ('g2', 'auto park'), ('g3', 'auto training')]))
    [('g1', 'park'), ('g1', 'training')]
    """
    queries = [Query(group, text) for (group, text) in queries if text.strip()]
    word_dict = defaultdict(set)
    for q in queries:
        for word in q.words:
            if len(word) > 2:
                word_dict[word].add(q)
    group_minus = defaultdict(set)
    for q in queries:
        other_sets = [word_dict[word] for word in q.words]
        others = reduce(operator.and_, other_sets)
        others.difference_update([q])
        minus_words = set()
        for o in others:
            minus_words.update(w for w in o.words if not w.startswith('-'))
        minus_words.difference_update(q.words)
        group_minus[q.group].update(minus_words)
    return [(group, minus_word)
            for (group, words) in group_minus.iteritems()
            for minus_word in words
            ]

def test_():
    import doctest
    doctest.testmod()

def main():
    import sys
    queries = file(sys.argv[1]).read().decode('utf-8').split('\n')
    print '\n'.join('\t'.join(pair).encode('utf-8')
            for pair in minus(q.rpartition('\t')[0::2] for q in queries))
    
if __name__ == '__main__':
    import sys
    if sys.argv[1] == '-t':
        test_()
    else:
        main()
