from .models import CandidateUrl
import random

def get_dups(entry_id, bannerids):
    sample = set(bannerids)
    if len(sample) != len(bannerids):
        return "Duplicate bannerids"
    existing = CandidateUrl.objects.exclude(list__pk=entry_id).filter(url__in=sample)
    if existing:
        return 'Banner ID collisions with other lists: {}'.format(
                ', '.join(fdup.url for fdup in existing[:10]))

def get_n_bannerids(n):
    sample = set()
    while True:
        while len(sample) < n:
            sample.add(str(random.randint(1000000, 9999999)))
        existing = CandidateUrl.objects.filter(url__in=sample)
        if not existing:
            return list(sample)
        for e in existing:
            sample.remove(e.url)
