from pyparsing import (
    oneOf, ZeroOrMore, QuotedString, Forward, Suppress,
    ParseSyntaxException, ParseException)

expr = Forward()
single = QuotedString("'")
term = single | (Suppress('(') - expr - Suppress(')'))
expr << (term - ZeroOrMore(oneOf(('&', '|')).suppress() - term))


def get_expressions(string):
    return expr.parseString(string, parseAll=True)


def valid_filter(string):
    string = string.strip()
    if not string:
        return (True, None)
    try:
        matchers = get_expressions(string)
    except ParseSyntaxException as e:
        return (False, str(e))
    except ParseException as e:
        return (False, str(e))
    for m in matchers:
        try:
            var, op, val = m.split(',', 2)
        except:
            return (False, m)
        if not (var.startswith('#') and (var.startswith(
                ('#feat:', '#uat:', '#req:',
                 '#product:', '#cookie:', '#header:')
            ) or var[1:] in (
            'referer', 'clid', 'clid_type', 'lr', 'ua', 'yp', 'ys', 'tld', 'lang', 'ts',
            'virus', 'apps', 'products', 'buckets', 'zmblt'
        )) and op in ('eq', 'match', 'ic_match', 'not_eq', 'not_match',
                      'ic_not_match', 'lt', 'gt')):
            return (False, m)
    return (True, None)
