import re

def substitute(template_object, var_values):
	if isinstance(template_object, basestring):
		if re.match('{{[a-z][a-z0-9_]+(:[a-z]+)?}}$', template_object):
			var, _, typename = template_object.strip('{}').partition(':')
			value_str = var_values.get(var, '0')
			try:
				if typename == 'int':
					return int(value_str)
				elif typename == 'num':
					if isinstance(value_str, float):
						return value_str
					if isinstance(value_str, basestring) and not value_str.isdigit():
						return float(value_str)
					return int(value_str)
			except ValueError:
				return 0
		return re.sub('{{[a-z][a-z0-9_]+}}',
			lambda m: unicode(var_values.get(m.group(0).strip('{}'), m.group(0))),
			template_object)
	elif isinstance(template_object, dict):
		for k, v in template_object.items():
			template_object[k] = substitute(v, var_values)
		return template_object
	elif isinstance(template_object, list):
		return [substitute(v, var_values) for v in template_object]
	else:
		return template_object
