from django.contrib import messages
from .models import Editor, AuthToken

def approved(login):
    if login in ['riddle', 'pecheny', 'myltsev', 'chikachoff']:
        return True
    return Editor.objects.filter(login=login).count() > 0

def get_approved_login(request):
    login = (
        request.session.get('yandex_login')
        or request.META.get('HTTP_X_YANDEX_LOGIN')
        or request.COOKIES.get('yandex_login'))

    if not login:
        auth = request.META.get('HTTP_AUTHORIZATION', '').partition(' ')
        if auth[0] == 'Token':
            try:
                login = AuthToken.objects.get(key=auth[2]).login
            except: pass

    if not login or not approved(login):
        messages.add_message(request, messages.ERROR,
                "Access not authorized for {}, please contact pecheny@".format(
                    login
                ) if login
                else 'You are not logged in.')
        return None
    return login
