# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('atom', '0009_auto_20151228_1752'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeployLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('timestamp', models.DateTimeField(auto_now=True, db_index=True)),
                ('text', models.CharField(max_length=300)),
            ],
            options={
                'ordering': ['timestamp'],
            },
        ),
        migrations.CreateModel(
            name='Deployment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('author', models.CharField(max_length=50)),
                ('comment', models.CharField(max_length=300)),
                ('created', models.DateTimeField(auto_now=True, db_index=True)),
                ('is_rollback', models.BooleanField(default=False)),
                ('state', models.CharField(default=b'new', max_length=20)),
                ('snapshot', models.ForeignKey(to='atom.Snapshot')),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
        migrations.DeleteModel(
            name='Counter',
        ),
        migrations.AddField(
            model_name='deploylog',
            name='deployment',
            field=models.ForeignKey(to='atom.Deployment'),
        ),
        migrations.AlterIndexTogether(
            name='deploylog',
            index_together=set([('deployment', 'timestamp')]),
        ),
    ]
