import requests


class NannyApi(object):
    # TODO: find out why https:// gives an error here
    root_url = 'http://nanny.yandex-team.ru/v2/services/'

    def __init__(self, token):
        self.token = token

    def get(self, url):
        return requests.get(self.root_url + url, headers=self.get_headers())

    def get_headers(self):
        return {'Auhorization': 'OAuth ' + self.token}

    def service_instances(self, service):
        return self.get(service + '/current_state/instances/').json()


def wait_for_version(ver, until, deployment=None):
    """
    Waits for candidates version >= `ver' to go live on *any* *single* production host.
    Returns the deployed version (>= `ver') or None if there was a timeout.
    """
    from django.conf import settings
    import time
    n = NannyApi(settings.NANNY_OAUTH_TOKEN)
    instances = n.service_instances('production_meta_rerankd')['result']
    while time.time() < until:
        for i in instances:
            try:
                unistat = requests.get('http://{hostname}:{port}/_golovan'.format(**i), timeout=1).json()
            except Exception:
                time.sleep(1)
                continue
            for k, v in unistat:
                if k.startswith('CLIENT-CandidatesVersion') and v >= ver:
                    return v
            time.sleep(0.5)
            if deployment:
                deployment.state_transition(deployment.state, deployment.state)
    return None
