import json
import requests
from .models import JsonStatDatum, AutoQuota, CandidateUrl
from collections import defaultdict
from six import iteritems
import datetime

class CandidateScores(object):
    def __init__(self, rtmr_stats):
        self.stats = rtmr_stats

    def __sub__(self, other):
        stat_diff = {}
        for list_id, v in self.stats.iteritems():
            diff_dict = {}
            other_dict = other.stats.get(list_id, {})
            for var, value in v.iteritems():
                diff_value = value - other_dict.get(var, 0)
                if diff_value:
                    diff_dict[var] = diff_value
            if diff_dict:
                stat_diff[list_id] = diff_dict
        return CandidateScores(stat_diff)


def rtmr_candidate_scores(production_list):
    j = requests.get('http://rtmr.search.yandex.net:8080/yandsearch',
                     params=dict(view='plain', table='atom/candidate_scores',
                     mrs=3000000, maxrecords=1, key=production_list))
    j = j.text.partition('\t')[2]
    if not j:
        return None
    j = json.loads(j)
    result = {}
    for key, stats in j.iteritems():
        stats = stats.get('v')
        if stats:
            stat_dict = {}
            for field in stats.split():
                var, value = field.split('=')
                stat_dict[var] = int(value)
            result[key] = stat_dict
    return result


def record_scores(production_list):
    scores = rtmr_candidate_scores(production_list)
    return JsonStatDatum.add(u'rtmr_scores\t' + production_list, scores)


def record_product_shares(production_list, old_scores, new_scores):
    diff = (CandidateScores(new_scores) - CandidateScores(old_scores)).stats
    bannerids = set(url.rpartition('/')[2] for url in diff)
    candidates = CandidateUrl.objects.filter(url__in=bannerids).values('url', 'product')
    candidates = {v['url']: v['product'] for v in candidates}
    result = {}
    for url, url_diff in iteritems(diff):
        shows = url_diff.get('show', 0)
        if not shows:
            continue
        product = candidates.get(url.rpartition('/')[2])
        result[product] = shows + result.get(product, 0)
    return JsonStatDatum.add(u'product_shows\t' + production_list, result)


def update_product_shares(production_list):
    scores = record_scores(production_list)
    previous_scores = JsonStatDatum.objects.filter(key=scores.key,
        timestamp__lt=scores.timestamp-datetime.timedelta(seconds=250),
        timestamp__gt=scores.timestamp-datetime.timedelta(hours=2)
        ).order_by('-timestamp')
    if not previous_scores:
        return
    previous_score = previous_scores[0]
    return record_product_shares(production_list, previous_score.json, scores.json)
