from .models import StatDatum
import unicodecsv as csv
import datetime
import requests
from celery import shared_task
from django.conf import settings
from django.core.cache import cache
from django.db.models import Sum, F
from collections import namedtuple
from six import iteritems

class semi(csv.excel):
    delimiter = ';'

def load_data(f):
    cr = csv.reader(f, dialect=semi, encoding='utf-8')
    cr.next() # skip header
    dates = set()
    rows = []
    for row in cr:
        if len(row) == 0:
            continue
        date, candidate, shows, clicks, installs = row
        candidate = candidate.partition(' ')[0]
        if (len(candidate) > 50) or candidate == '_total_':
            continue
        parsed_date = datetime.datetime.strptime(date, '%d.%m.%Y').date()
        dates.add(parsed_date)
        rows.append(StatDatum(date=parsed_date, candidate=candidate,
            clicks=int(clicks), shows=int(shows), installs=int(installs)))
    StatDatum.objects.filter(date__gte=min(dates)).delete()
    StatDatum.objects.bulk_create(rows)


def get_stats(days=7):
    data = requests.get('https://stat.yandex-team.ru/Distribution/Others/AtomBanners/v4'
            '?scale=d_by_i_sum&_incl_fields=clicks&_incl_fields=shows'
            '&_incl_fields=installs'
            '&candidate=_in_table_&_type=csv&_allow_transpose=0&rich=0',
            params={'_period_distance': days},
            headers={'StatRobotAuth': settings.STAT_ROBOT_AUTH})
    load_data(l.encode('utf-8') for l in data.text.split('\n'))


Aggregate = namedtuple('Aggregate', 'since until data')

def candidate_top(span_days=7, product=''):
    assert span_days >= 1
    yesterday = datetime.date.today() - datetime.timedelta(days=1)
    from_date = yesterday - datetime.timedelta(days=span_days-1)
    return Aggregate(from_date, yesterday, StatDatum.objects.raw(
            'select * from ('
            'select min(atom_statdatum.id) as id, '
            'sum(clicks) as sum_clicks, sum(shows) as sum_shows, '
            'sum(installs) as sum_installs, '
            'list_id '
            'from atom_statdatum left join atom_candidateurl '
            'on (atom_statdatum.candidate = atom_candidateurl.url) '
            'where atom_statdatum.date between %s and %s '
            'and clicks > 10 '
            'and (%s or atom_candidateurl.product = %s) '
            'group by candidate, list_id) as Q '
            'order by '
            '(sum_installs/(sum_shows+0.001)) desc, '
            '(sum_clicks/(sum_shows+0.001)) desc',
            [from_date, yesterday, False if product else True, product]
            ))


def candidate_stats(list_id, span_days=7):
    assert span_days >= 1
    yesterday = datetime.date.today() - datetime.timedelta(days=1)
    from_date = yesterday - datetime.timedelta(days=span_days-1)
    return Aggregate(from_date, yesterday, StatDatum.objects.raw(
            'select * from ('
            'select min(atom_statdatum.id) as id, '
            'atom_statdatum.candidate as candidate, '
            'sum(clicks) as sum_clicks, sum(shows) as sum_shows, '
            'sum(installs) as sum_installs '
            'from atom_statdatum left join atom_candidateurl '
            'on (atom_statdatum.candidate = atom_candidateurl.url) '
            'where atom_statdatum.date between %s and %s '
            'and list_id=%s '
            'group by candidate) as Q ',
            #'order by atom_statdatum.candidate asc',
            [from_date, yesterday, list_id]
            ))


def statface_candidate_dict():
    key = 'vcfs::atombanners_candidate'
    d = cache.get(key)
    if d is None:
        id_to_bannerid = requests.get(
                'https://stat.yandex-team.ru/_api/dictionary',
                params={'name': key},
                headers={'StatRobotAuth': settings.STAT_ROBOT_AUTH}
        ).json()
        d = {v: k for k, v in iteritems(id_to_bannerid)}
        cache.set(key, d, 600)
    return d


def join_authors(span_days=7):
    assert span_days >= 1
    yesterday = datetime.date.today() - datetime.timedelta(days=1)
    from_date = yesterday - datetime.timedelta(days=span_days-1)
    return Aggregate(from_date, yesterday, StatDatum.objects.raw(
            'select min(atom_statdatum.id) as id, '
            'sum(clicks) as clicks, sum(shows) as shows, '
            'sum(installs) as installs, author '
            'from atom_statdatum left join atom_candidateurl '
            'on (atom_statdatum.candidate = atom_candidateurl.url) '

            'where atom_statdatum.date between %s and %s '
            'group by author order by (installs/(shows+0.001)) desc',
            [from_date, yesterday]
            ))
