# -*- coding: utf-8 -*-
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support.ui import Select
from selenium.common.exceptions import NoSuchElementException
from selenium.common.exceptions import NoAlertPresentException
import unittest, time, re
import django.test

class AaBanneridCollisionCase1(django.test.LiveServerTestCase):
    def setUp(self):
        self.driver = webdriver.PhantomJS(service_log_path='/tmp/phantomjs.log')
        self.driver.implicitly_wait(5)
        self.base_url = self.live_server_url
        self.verificationErrors = []
        self.accept_next_alert = True

    def test_aa_01_create_list(self):
        driver = self.driver
        driver.get(self.live_server_url + "/atom/")
        driver.add_cookie({'name': 'yandex_login', 'value': 'myltsev'})
        driver.find_element_by_link_text("Add new collection").click()
        driver.find_element_by_id("id_slug").clear()
        driver.find_element_by_id("id_slug").send_keys("list_alpha")
        driver.find_element_by_id("id_json").clear()
        driver.find_element_by_id("id_json").send_keys("[{\"internal-url\": \"cand/001\"}]")
        driver.find_element_by_name("save").click()
        self.assertRegexpMatches(driver.current_url, r"^[\s\S]*/atom/$")


    def test_aa_02_bannerid_collision_case1(self):
        driver = self.driver
        driver.get(self.live_server_url + "/atom/")
        driver.add_cookie({'name': 'yandex_login', 'value': 'myltsev'})
        driver.find_element_by_link_text("Add new collection").click()
        driver.find_element_by_id("id_slug").clear()
        driver.find_element_by_id("id_slug").send_keys("list_alpha")
        driver.find_element_by_id("id_json").clear()
        driver.find_element_by_id("id_json").send_keys("[{\"internal-url\": \"cand/001\"}]")
        driver.find_element_by_name("save").click()
        driver.find_element_by_link_text("Add new collection").click()
        driver.find_element_by_id("id_slug").clear()
        driver.find_element_by_id("id_slug").send_keys("list_bravo")
        driver.find_element_by_id("id_json").clear()
        driver.find_element_by_id("id_json").send_keys("[{\"internal-url\": \"cand/001\"}]")
        driver.find_element_by_name("save").click()
        # ERROR: Caught exception [Error: unknown strategy [class] for locator [class=help-block]]
        driver.find_element_by_id("id_json").clear()
        driver.find_element_by_id("id_json").send_keys("[\n    {\n        \"internal-url\": \"cand/002\"\n    }\n]")
        driver.find_element_by_name("save").click()
        self.assertRegexpMatches(driver.current_url, r"^[\s\S]*/atom/$")
        self.assertRegexpMatches(driver.find_element_by_tag_name("BODY").text, r"^[\s\S]*list_alpha[\s\S]*list_bravo[\s\S]*$")

    def is_element_present(self, how, what):
        try: self.driver.find_element(by=how, value=what)
        except NoSuchElementException as e: return False
        return True

    def is_alert_present(self):
        try: self.driver.switch_to_alert()
        except NoAlertPresentException as e: return False
        return True

    def close_alert_and_get_its_text(self):
        try:
            alert = self.driver.switch_to_alert()
            alert_text = alert.text
            if self.accept_next_alert:
                alert.accept()
            else:
                alert.dismiss()
            return alert_text
        finally: self.accept_next_alert = True

    def tearDown(self):
        self.driver.quit()
        self.assertEqual([], self.verificationErrors)

if __name__ == "__main__":
    unittest.main()
