#!/bin/bash -efx
cd "$1"
trie_name="${4:-atom-candidates}"
echo "building trie $trie_name"
x=${3:-`date +%s`}
querydata_indexer -f 4096,50000000 -L codedblobtrie -jJE -N structkey -S $trie_name -o $trie_name.trie -V $x -i $2
echo "build ts: ${x}"
echo "preparing trie dir"
rm -rf 000
mkdir 000
mv $trie_name.trie "000/$trie_name.trie.${x}"
echo "creating tag file"
echo "$x" > $trie_name.trie.tag
echo "sending trie"
QUERYDATA=ws37-537.search.yandex.net::querydata
rsync -r -v 000 $QUERYDATA/
echo "sending tag file"
rsync -r -v $trie_name.trie.tag  $QUERYDATA/
echo "done"
