from django.conf.urls import url
from django.views.generic.base import TemplateView
from .views import (upload_txt, list_view, entry_edit, dump, rollout,
        dump_zip,
        unlock_my_entries,
        disguise, freeze,
        force_deploy,
        fail_deploy,
        const_add,
        quota, quota_edit,
        visual_search,
        api, top, top_candidates,
        EditorList, EditorCreate, EditorDelete, SnapshotList,
        LogList, diff, minus, bulk_edit, bulk_edit_visual, pick_candidates,
        choose_list, substitutions, combinations, add_creatives,
        TemplateList, TemplateCreate, TemplateUpdate, TemplateDelete,
        AutoQuotaCreate, AutoQuotaUpdate, AutoQuotaDelete,
        statface_redirect,
        EntryView, EntryStats)

urlpatterns = [
    url(r'^upload_txt/', upload_txt, name='upload_txt'),
    url(r'^$', list_view, name='list_view'),
    url(r'^collection/(?P<pk>[a-f0-9]+)$', EntryStats.as_view(), name='entry_stats'),
    url(r'^collection/(?P<pk>[a-f0-9]+)/edit/$', bulk_edit, name='bulk_edit'),
    url(r'^bulk_edit_visual/$', bulk_edit_visual, name='bulk_edit_visual'),
    url(r'^const_add/$', const_add, name='const_add'),
    url(r'^view/(?P<pk>[a-f0-9]+)$', EntryView.as_view(), name='entry_view'),
    url(r'^edit/$', entry_edit, name='entry_add'),
    url(r'^edit/(?P<entry_id>[a-f0-9]+)$', entry_edit, name='entry_edit'),
    url(r'^tsv/$', dump, name='get_tsv'),
    url(r'^tsv/(?P<snapshot>[a-f0-9]+)$', dump, name='dump_snapshot'),
    url(r'^editors/$', EditorList.as_view(), name='editor_list'),
    url(r'^editor_add/$', EditorCreate.as_view(), name='editor_add'),
    url(r'^editor_delete/(?P<pk>[-a-z0-9_]+)$', EditorDelete.as_view(), name='editor_delete'),
    url(r'^snapshots/$', SnapshotList.as_view(), name='snapshot_list'),
    url(r'^snapshots/(?P<snapshot>[a-f0-9]+)/candidates.zip$', dump_zip, name='dump_zip'),
    url(r'^rollout/$', rollout, name='rollout'),
    url(r'^search/(?P<query>.+)$', visual_search, name='search'),
    url(r'^search/$', visual_search, name='search_noquery'),
    url(r'^logs/$', LogList.as_view(), name='logs'),
    url(r'^deployment/(?P<depl>[a-f0-9]+)/force$', force_deploy, name='force_deploy'),
    url(r'^deployment/(?P<depl>[a-f0-9]+)/fail$', fail_deploy, name='fail_deploy'),
    url(r'^revert/(?P<snapshot>[a-f0-9]+)$', upload_txt, name='revert'),
    url(r'^unlock/$', unlock_my_entries, name='unlock'),
    url(r'^templates/$', TemplateList.as_view(), name='template_list'),
    url(r'^templates/add/$', TemplateCreate.as_view(), name='template_add'),
    url(r'^templates/edit/(?P<slug>[-a-zA-Z_0-9]+)$',
        TemplateUpdate.as_view(), name='template_update'),
    url(r'^templates/delete/(?P<slug>[-a-zA-Z_0-9]+)$',
        TemplateDelete.as_view(), name='template_delete'),
    url(r'^minus/', minus, name='minus'),
    url(r'^templates/(?P<slug>[-a-zA-Z_0-9]+)/choose_list/$',
        choose_list, name='choose_list'),
    url(r'^templates/(?P<slug>[-a-z_0-9]+)/dst/(?P<list_id>[-a-zA-Z0-9]+)/$',
        substitutions, name='substitutions'),
    url(r'^templates/(?P<slug>[-a-zA-Z_0-9]+)/pick-candidates/(?P<list_id>[-a-zA-Z0-9]+)/$',
        pick_candidates, name='pick_candidates'),
    url(r'^templates/(?P<slug>[-a-zA-Z_0-9]+)/combine/$',
        combinations, name='combinations'),
    url(r'^add_creatives/$', add_creatives, name='add_creatives'),
    url(r'^diff/([a-f0-9]+)/([a-f0-9]+)$', diff, name='diff'),
    url(r'^diff/$', diff, name='diff2'),
    #url(r'^disguise/$', disguise, name='disguise'),
    url(r'^freeze/(on|off)/$', freeze, name='freeze'),
    url(r'^spa/$', TemplateView.as_view(template_name='atom/spa.html')),
    url(r'^top/$', top_candidates, name='top'),
    url(r'^quota/$', quota_edit, name='quota'),
    url(r'^quota/add/$', AutoQuotaCreate.as_view(), name='quota_add'),
    url(r'^quota/edit/(?P<slug>[-/a-zA-Z_0-9]+)$',
        AutoQuotaUpdate.as_view(), name='quota_update'),
    url(r'^quota/delete/(?P<slug>[-/a-zA-Z_0-9]+)$',
        AutoQuotaDelete.as_view(), name='quota_delete'),
    url(r'^top/authors/$', top, name='top_authors'),
    url(r'^statface_redirect/(?P<bannerid>.+)$', statface_redirect, name='statface_redirect'),
    url(r'^api/v1/(?P<endpoint>.+)$', api),
    url(r'^api/token', api),
]
