from facebookads import FacebookSession, FacebookAdsApi
from facebookads.objects import AdUser, AdGroup, AdSet, AdCampaign, AdCreative, AdAccount
from django.conf import settings
import types, os, logging, ConfigParser
__author__ = 'aalogachev'

# reading config
def isField(x): #x is tuple of field name and value
    return ((not callable(x[0])) and (not isinstance(x[1], (type, types.ClassType))) and (not x[0].startswith('__')))

def get_fields(klass):
    return [x[1] for x in klass.Field.__dict__.items() if isField(x)]

ad_campaign_fields = get_fields(AdCampaign)
ad_campaign_fields.remove('is_completed')

ad_set_fields = get_fields(AdSet)

ad_group_fields = get_fields(AdGroup)
ad_group_fields.remove('failed_delivery_checks')
ad_group_fields.remove('adgroup_status')
ad_group_fields.remove('social_prefs')
ad_group_fields.remove('campaign_id')
ad_group_fields.remove('view_tags')
ad_group_fields.remove('redownload')
ad_group_fields.remove('tracking_specs')
ad_group_fields.remove('creative')
ad_group_fields.remove('adgroup_review_feedback')
ad_group_fields.remove('conversion_specs')


ad_creative_fields = {
    AdCreative.Field.actor_id,
    AdCreative.Field.actor_name,
    AdCreative.Field.adlabels,
    # AdCreative.Field.applink_treatment,
    AdCreative.Field.body,
    AdCreative.Field.call_to_action_type,
    # AdCreative.Field.filename,
    AdCreative.Field.follow_redirect,
    AdCreative.Field.id,
    AdCreative.Field.image_crops,
    # AdCreative.Field.image_file,
    AdCreative.Field.image_hash,
    AdCreative.Field.image_url,
    AdCreative.Field.link_deep_link_url,
    AdCreative.Field.link_url,
    AdCreative.Field.name,
    AdCreative.Field.object_id,
    AdCreative.Field.object_store_url,
    AdCreative.Field.object_story_id,
    AdCreative.Field.object_story_spec,
    AdCreative.Field.object_type,
    AdCreative.Field.object_url,
    AdCreative.Field.preview_url,
    AdCreative.Field.product_set_id,
    AdCreative.Field.template_url,
    AdCreative.Field.thumbnail_url,
    AdCreative.Field.title,
    AdCreative.Field.video_id,
}
ad_creative_fields = get_fields(AdCreative)


class ApiConnector(object):

    def __init__(self):
        my_app_id = settings.FACEBOOK_APP_ID
        my_app_secret = settings.FACEBOOK_APP_SECRET
        my_access_token = 'CAANVX4oIqDgBAJx8zEU21sFIgabNMRuCy75J5jl7LKCBH7Pq5Icowi930cKUJFm3P9Gc4KsOdbvK0IkwbkquKbzu7d8GWUC8x88FOU8CoF9VsZCBesnrSNsvX13ArQevYYD0AbINXn39GxZAZCCBZBzRYpIEa1woJt4A2eZC9lA8crwK7EbE6cuqAcnwFrwIXnCVdGZAWUJyWyZCmQlOQ8y'
        my_adv_account_id = '10155873283260577'

        ### Setup session and api objects
        session = FacebookSession(
            my_app_id,
            my_app_secret,
            my_access_token,
        )
        self.api = FacebookAdsApi(session)

        self.account = AdAccount('act_{0}'.format(my_adv_account_id), api=self.api)

        #setting default read fields
        AdCampaign.set_default_read_fields(ad_campaign_fields)
        AdSet.set_default_read_fields(ad_set_fields)
        AdGroup.set_default_read_fields(ad_group_fields)
        AdCreative.set_default_read_fields(ad_creative_fields)


    def get_account(self):
        return self.account
