from django import forms
from django.core.urlresolvers import reverse, reverse_lazy
from crispy_forms.helper import FormHelper
from crispy_forms.layout import Submit

class TokenAddForm(forms.Form):
    short_lived_token = forms.CharField()

    @property
    def helper(self):
        h = FormHelper()
        h.form_action = reverse('token_add')
        h.add_input(Submit('add', 'add'))
        return h

