from __future__ import division
from api import get_json
import json
import math
import datetime

__author__ = 'aalogachev'

SWITCH_COUNTER_ID=31119731
SWITCH_INSTALL_GOAL_ID=11840621


def get_visits_and_conversion_rates_for(facebook_campaign_id, counter_id, goal_id, gender, age, date_start, date_end):
    params = {
        'metrics' : 'ym:s:visits,ym:s:goal{0}conversionRate'.format(goal_id),
        'filters' : 'EXISTS(ym:s:paramsLevel1==\'f_campaign_id\' AND ym:s:paramsLevel2==\'{0}\') '
                    'AND EXISTS(ym:s:paramsLevel1==\'u_gender\' AND ym:s:paramsLevel2==\'{1}\') '
                    'AND EXISTS(ym:s:paramsLevel1==\'u_age\' AND ym:s:paramsLevel2==\'{2}\')'.format(facebook_campaign_id, gender, age),
        #'dimensions' : 'ym:s:startURLPath', #,ym:s:paramsLevel1,ym:s:paramsLevel2
        'date1' : date_start.strftime('%Y-%m-%d'),
        'date2' : date_end.strftime('%Y-%m-%d'),
    }
    report_json = get_json(params, counter_id)
    for data in report_json['data']:
        #FIXME check that this result is correct
        return data['metrics']

def get_ruswitch_stats(filters, date_end):
    params = {
        'metrics' : 'ym:s:visits,ym:s:goal{0}conversionRate'.format(SWITCH_INSTALL_GOAL_ID),
        'filters' : filters,
        #'dimensions' : 'ym:s:startURLPath', #,ym:s:paramsLevel1,ym:s:paramsLevel2
        'date1' : (date_end - datetime.timedelta(days=1)).strftime('%Y-%m-%d'),
        'date2' : (date_end - datetime.timedelta(days=1)).strftime('%Y-%m-%d'),
        #'date2' : date_end.strftime('%Y-%m-%d'),
    }
    report_json = get_json(params, SWITCH_COUNTER_ID)
    for data in report_json['data']:
        return data['metrics']
    return (0,0)

def get_visits_and_conversion_rates_for(facebook_adset_id, counter_id, goal_id, date_start, date_end):
    params = {
        'metrics' : 'ym:s:visits,ym:s:goal{0}conversionRate'.format(goal_id),
        'filters' : 'EXISTS(ym:s:paramsLevel1==\'f_adset_id\' AND ym:s:paramsLevel2==\'{0}\') '.format(facebook_adset_id),
        #'dimensions' : 'ym:s:startURLPath', #,ym:s:paramsLevel1,ym:s:paramsLevel2
        'date1' : date_start.strftime('%Y-%m-%d'),
        'date2' : date_end.strftime('%Y-%m-%d'),
    }
    report_json = get_json(params, counter_id)
    for data in report_json['data']:
        return data['metrics']
    #default values
    return (0,0)


def calculate_cpc_estimate_and_delta(v_cvr, desired_cpa):
    cpc_est = desired_cpa*v_cvr[1]/100
    if (v_cvr[0] != 0):
        #FIXME think about case non-zero visits and zero conversion rate
        delta_estimate =  math.sqrt((100-v_cvr[1])*v_cvr[1]/v_cvr[0])
        cpc_delta_estimate = desired_cpa*delta_estimate/100
    else:
        cpc_delta_estimate = desired_cpa*0.5
    return (cpc_est, cpc_delta_estimate)

def test():
    for gender in (1,2):
        for age in ('13-17', '18-24', '25-34', '35-44', '45-54', '55-65'):
            v_cvr = get_visits_and_conversion_rates_for(6028521095671, SWITCH_COUNTER_ID, SWITCH_INSTALL_GOAL_ID, gender, age, datetime.date.today(), datetime.date.today() - datetime.timedelta(days=7))
            print u'cvr[{0},{1}] = {2}'.format(gender, age, v_cvr[1])
            cpc_est, cpc_delta_est = calculate_cpc_estimate_and_delta(v_cvr, 1)
            print u'CPC_est = {1}\u00B1{2}'.format(0, cpc_est, cpc_delta_est)

