from __future__ import unicode_literals
from django.db import models

SERVICES = [
    ('facebook', 'Facebook'),
    ('metrika', 'Metrika'),
    ('google', 'Google'),
]

class Account(models.Model):
    # Facebok/Adwords ad account, Metrika counter, etc.
    service = models.CharField(max_length=50, choices=SERVICES)
    name = models.CharField(max_length=200)
    identifier = models.CharField(max_length=200)

class Resource(models.Model):
    account = models.ForeignKey(Account)
    identifier = models.CharField(max_length=500)
    kind = models.CharField(max_length=20)
    props = models.TextField()

class Client(models.Model):
    service = models.CharField(max_length=50, choices=SERVICES)
    client_id = models.TextField()
    client_secret = models.TextField()
    props = models.TextField()
    maintainer = models.CharField(max_length=50) # yandex login

class Token(models.Model):
    service = models.CharField(max_length=50, choices=SERVICES)
    client = models.ForeignKey(Client, null=True)
    author = models.CharField(max_length=50, null=True)
    props = models.TextField(null=True)
    value = models.TextField()
    created = models.DateTimeField(auto_now_add=True)
    ttl = models.IntegerField()

    def asterisk(self):
        return self.value[:5] + '***' + self.value[-5:]
    def __unicode__(self):
        return 'Token[{}, {}]'.format(self.service, self.asterisk())
