from __future__ import absolute_import
from django.shortcuts import render
from django.core.urlresolvers import reverse
from .models import Token
from .forms import TokenAddForm
from django.views.generic import ListView
from django.http import HttpResponseRedirect
from facebook import GraphAPI
from django.conf import settings
from django.contrib import messages

import urllib
import requests
import json

def campaign_list(request):
    pass

def get_login(request):
    return request.META.get('HTTP_X_YANDEX_LOGIN')

def fb_redir(request):
    code = request.GET['code']
    r = requests.get('https://graph.facebook.com/v2.3/oauth/access_token',
            params=dict(client_id=settings.FACEBOOK_APP_ID,
                    redirect_uri='https://switch.v.yandex-team.ru' + reverse(fb_redir),
                    code=code, client_secret=settings.FACEBOOK_APP_SECRET)).json()
    Token.objects.create(service='facebook', value=r['access_token'], ttl=r['expires_in'],
            props=json.dumps(dict(type=r['token_type'])), author=get_login(request))
    return HttpResponseRedirect(reverse('token_list'))

class TokenList(ListView):
    model = Token
    def get_context_data(self, **kwargs):
        context = super(TokenList, self).get_context_data(**kwargs)
        context['add_form'] = TokenAddForm()
        context['facebook_login'] = ('https://www.facebook.com/dialog/oauth?' +
                urllib.urlencode(dict(
                    client_id=settings.FACEBOOK_APP_ID,
                    redirect_uri='https://switch.v.yandex-team.ru' + reverse(fb_redir),
                    scope='ads_management,ads_read')))
        return context

def token_add(request):
    form = TokenAddForm(request.POST)
    if form.is_valid():
        gapi = GraphAPI(form.cleaned_data['short_lived_token'])
        long_token = json.loads(gapi.extend_access_token(
                settings.FACEBOOK_APP_ID,
                settings.FACEBOOK_APP_SECRET))
        Token.objects.create(value=long_token['access_token'],
                ttl=long_token['expires'], service='facebook')
        messages.add_message(request, messages.INFO, 'Added new token')
    return HttpResponseRedirect(reverse(TokenList))

def adsets(request):
    return render(request, 'channels/logs.html', {})

def metrika(request):
    from .metrika import conversions
    import datetime
    stats = conversions.get_ruswitch_stats("ym:s:from=='facebook_PanoramaSPB_bid'",
            datetime.date.today())
    stats2 = conversions.get_ruswitch_stats("ym:s:from=='facebook_PanoramaSPB_auto'",
            datetime.date.today())
    spent = 2976.07
    spent2 = 1901.38
    convs = stats[0]*stats[1]/100
    convs2 = stats2[0]*stats2[1]/100
    ctx = dict(spent=spent, visits=stats[0], convs=convs, cpa=(spent / convs),
            spent2=spent2, visits2=stats2[0], convs2=convs2, cpa2=(spent2/convs2))
    return render(request, 'channels/stats.html', ctx)

def fbapi(request):
    pass
