Expression
  = _ head:Term tail:(_ ("|" / "||") _ Term)* _ {
      if (tail.length == 0)
        return head;
      var result = ["|", head], i;

      for (i = 0; i < tail.length; i++) {
        result.push(tail[i][3]);
      }

      return result;
    }

Term
  = head:Factor tail:(_ ("&" / "&&") _ Factor)* {
      if (tail.length == 0)
        return head;
      var result = ["&", head], i;

      for (i = 0; i < tail.length; i++) {
        result.push(tail[i][3]);
      }

      return result;
    }

Matcher
  = varname:VarPath _ operation:("!~"/"~"/"="/"=="/"!="/"<"/">") _ value:Value {
      if (operation == "==")
        return ["=", varname, value]; 
      return [operation, varname, value];
    }

Factor
  = "(" expr:Expression ")" { return expr; }
  / Matcher

Var "variable name" = [-_a-z0-9/]+
VarPath = Var ("." Var)* { return text(); }

Value "value"
  = [^"][^)|& ]* { return text(); }
  / '"' val:[^"]* '"' { return val.join(""); }
  
_ "whitespace"
  = [ \t\n\r]*
